"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSearchPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverlessSearchSettings = require("@kbn/serverless-search-settings");
var _api_key_routes = require("./routes/api_key_routes");
var _indices_routes = require("./routes/indices_routes");
var _connectors_routes = require("./routes/connectors_routes");
var _telemetry = require("./collectors/connectors/telemetry");
var _mapping_routes = require("./routes/mapping_routes");
var _ingest_pipeline_routes = require("./routes/ingest_pipeline_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessSearchPlugin {
  constructor(initializerContext) {
    // @ts-ignore config is not used for now
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.config = initializerContext.config.get();
    this.logger = initializerContext.logger.get();
  }
  async createDefaultDataView(core, dataViews) {
    const dataViewsService = await dataViews.dataViewsServiceFactory(core.savedObjects.createInternalRepository(), core.elasticsearch.client.asInternalUser, undefined, true);
    const dataViewExists = await dataViewsService.get('default_all_data_id').catch(() => false);
    if (!dataViewExists) {
      const defaultDataViewExists = await dataViewsService.defaultDataViewExists();
      if (!defaultDataViewExists) {
        await dataViewsService.createAndSave({
          allowNoIndex: false,
          name: 'default:all-data',
          title: '*,-.*',
          id: 'default_all_data_id'
        });
      }
    }
    return;
  }
  setup({
    getStartServices,
    http
  }, {
    serverless,
    usageCollection
  }) {
    const router = http.createRouter();
    const dependencies = {
      http,
      logger: this.logger,
      router,
      getSecurity: async () => {
        const [, {
          security
        }] = await getStartServices();
        return security;
      }
    };
    (0, _api_key_routes.registerApiKeyRoutes)(dependencies);
    (0, _connectors_routes.registerConnectorsRoutes)(dependencies);
    (0, _indices_routes.registerIndicesRoutes)(dependencies);
    (0, _mapping_routes.registerMappingRoutes)(dependencies);
    (0, _ingest_pipeline_routes.registerIngestPipelineRoutes)(dependencies);
    if (usageCollection) {
      (0, _telemetry.registerTelemetryUsageCollector)(usageCollection, this.logger);
    }
    serverless.setupProjectSettings(_serverlessSearchSettings.SEARCH_PROJECT_SETTINGS);
    return {};
  }
  start(core, {
    dataViews
  }) {
    this.createDefaultDataView(core, dataViews).catch(() => {});
    return {};
  }
  stop() {}
}
exports.ServerlessSearchPlugin = ServerlessSearchPlugin;