"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_EXCEPTION_LIST_SIZE = exports.MAXIMUM_SMALL_VALUE_LIST_SIZE = exports.MAXIMUM_SMALL_IP_RANGE_VALUE_LIST_DASH_SIZE = exports.LIST_URL = exports.LIST_PRIVILEGES_URL = exports.LIST_ITEM_URL = exports.LIST_INDEX = exports.INTERNAL_LIST_URL = exports.INTERNAL_FIND_LISTS_BY_SIZE = exports.INTERNAL_EXCEPTION_LIST_URL = exports.INTERNAL_EXCEPTION_FILTER = exports.INTERNAL_EXCEPTIONS_LIST_ENSURE_CREATED_URL = exports.EXCEPTION_LIST_URL = exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = exports.EXCEPTION_LIST_NAMESPACE = exports.EXCEPTION_LIST_ITEM_URL = exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = exports.ENDPOINT_TRUSTED_APPS_LIST_ID = exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = exports.ENDPOINT_LIST_URL = exports.ENDPOINT_LIST_NAME = exports.ENDPOINT_LIST_ITEM_URL = exports.ENDPOINT_LIST_ID = exports.ENDPOINT_LIST_DESCRIPTION = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = exports.ENDPOINT_EVENT_FILTERS_LIST_ID = exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = exports.ENDPOINT_BLOCKLISTS_LIST_NAME = exports.ENDPOINT_BLOCKLISTS_LIST_ID = exports.ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = exports.ENDPOINT_ARTIFACT_LIST_IDS = exports.ENDPOINT_ARTIFACT_LISTS = void 0;
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Value list routes
 */
const LIST_URL = exports.LIST_URL = '/api/lists';
const LIST_INDEX = exports.LIST_INDEX = `${LIST_URL}/index`;
const LIST_ITEM_URL = exports.LIST_ITEM_URL = `${LIST_URL}/items`;
const LIST_PRIVILEGES_URL = exports.LIST_PRIVILEGES_URL = `${LIST_URL}/privileges`;

/**
 * Internal value list routes
 */
const INTERNAL_LIST_URL = exports.INTERNAL_LIST_URL = '/internal/lists';
const INTERNAL_FIND_LISTS_BY_SIZE = exports.INTERNAL_FIND_LISTS_BY_SIZE = `${INTERNAL_LIST_URL}/_find_lists_by_size`;
const INTERNAL_EXCEPTION_FILTER = exports.INTERNAL_EXCEPTION_FILTER = `${INTERNAL_LIST_URL}/_create_filter`;

/**
 * Exception list routes
 */
const EXCEPTION_LIST_URL = exports.EXCEPTION_LIST_URL = '/api/exception_lists';
const EXCEPTION_LIST_ITEM_URL = exports.EXCEPTION_LIST_ITEM_URL = '/api/exception_lists/items';

/**
 * Internal exception list routes
 */
const INTERNAL_EXCEPTION_LIST_URL = exports.INTERNAL_EXCEPTION_LIST_URL = `/internal${EXCEPTION_LIST_URL}`;
const INTERNAL_EXCEPTIONS_LIST_ENSURE_CREATED_URL = exports.INTERNAL_EXCEPTIONS_LIST_ENSURE_CREATED_URL = `${INTERNAL_EXCEPTION_LIST_URL}/_create`;

/**
 * Exception list spaces
 */
const EXCEPTION_LIST_NAMESPACE_AGNOSTIC = exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = 'exception-list-agnostic';
const EXCEPTION_LIST_NAMESPACE = exports.EXCEPTION_LIST_NAMESPACE = 'exception-list';

/**
 * Specific routes for the single global space agnostic endpoint list
 */
const ENDPOINT_LIST_URL = exports.ENDPOINT_LIST_URL = '/api/endpoint_list';

/**
 * Specific routes for the single global space agnostic endpoint list. These are convenience
 * routes where they are going to try and create the global space agnostic endpoint list if it
 * does not exist yet or if it was deleted at some point and re-create it before adding items to
 * the list
 */
const ENDPOINT_LIST_ITEM_URL = exports.ENDPOINT_LIST_ITEM_URL = '/api/endpoint_list/items';

/**
 * This ID is used for _both_ the Saved Object ID and for the list_id
 * for the single global space agnostic endpoint list
 */
const ENDPOINT_LIST_ID = exports.ENDPOINT_LIST_ID = 'endpoint_list';

/** The name of the single global space agnostic endpoint list */
const ENDPOINT_LIST_NAME = exports.ENDPOINT_LIST_NAME = 'Endpoint Security Exception List';

/** The description of the single global space agnostic endpoint list */
const ENDPOINT_LIST_DESCRIPTION = exports.ENDPOINT_LIST_DESCRIPTION = 'Endpoint Security Exception List';
const MAX_EXCEPTION_LIST_SIZE = exports.MAX_EXCEPTION_LIST_SIZE = 10000;
const MAXIMUM_SMALL_VALUE_LIST_SIZE = exports.MAXIMUM_SMALL_VALUE_LIST_SIZE = 65536;
const MAXIMUM_SMALL_IP_RANGE_VALUE_LIST_DASH_SIZE = exports.MAXIMUM_SMALL_IP_RANGE_VALUE_LIST_DASH_SIZE = 200;

/**
 * List definitions for Endpoint Artifact
 */
const ENDPOINT_ARTIFACT_LISTS = exports.ENDPOINT_ARTIFACT_LISTS = (0, _std.deepFreeze)({
  trustedApps: {
    id: 'endpoint_trusted_apps',
    name: 'Endpoint Security Trusted Apps List',
    description: 'Endpoint Security Trusted Apps List'
  },
  eventFilters: {
    id: 'endpoint_event_filters',
    name: 'Endpoint Security Event Filters List',
    description: 'Endpoint Security Event Filters List'
  },
  hostIsolationExceptions: {
    id: 'endpoint_host_isolation_exceptions',
    name: 'Endpoint Security Host isolation exceptions List',
    description: 'Endpoint Security Host isolation exceptions List'
  },
  blocklists: {
    id: 'endpoint_blocklists',
    name: 'Endpoint Security Blocklists List',
    description: 'Endpoint Security Blocklists List'
  }
});

/**
 * The IDs of all Endpoint artifact lists
 */
const ENDPOINT_ARTIFACT_LIST_IDS = exports.ENDPOINT_ARTIFACT_LIST_IDS = Object.freeze(Object.values(ENDPOINT_ARTIFACT_LISTS).map(({
  id
}) => id));

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_TRUSTED_APPS_LIST_ID = exports.ENDPOINT_TRUSTED_APPS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.trustedApps.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_TRUSTED_APPS_LIST_NAME = exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.trustedApps.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.trustedApps.description;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_EVENT_FILTERS_LIST_ID = exports.ENDPOINT_EVENT_FILTERS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.eventFilters.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_EVENT_FILTERS_LIST_NAME = exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.eventFilters.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.eventFilters.description;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.hostIsolationExceptions.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.hostIsolationExceptions.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.hostIsolationExceptions.description;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_BLOCKLISTS_LIST_ID = exports.ENDPOINT_BLOCKLISTS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.blocklists.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_BLOCKLISTS_LIST_NAME = exports.ENDPOINT_BLOCKLISTS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.blocklists.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
const ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = exports.ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.blocklists.description;