"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigationTree = void 0;
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _navigation_tree = require("@kbn/security-solution-navigation/navigation_tree");
var _links = require("@kbn/security-solution-navigation/links");
var _stack_management_navigation = require("./stack_management_navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolutionServerless.navLinks.projectType.title', {
  defaultMessage: 'Security'
});
const createNavigationTree = services => ({
  body: [{
    type: 'navGroup',
    id: 'security_solution_nav',
    title: SOLUTION_NAME,
    icon: 'logoSecurity',
    breadcrumbStatus: 'hidden',
    isCollapsible: false,
    defaultIsCollapsed: false,
    children: [{
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'discover'
      }, _navigation_tree.defaultNavigationTree.dashboards()]
    }, {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.rules(), {
        id: _securitySolutionNavigation.SecurityPageName.alerts,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.alerts)
      }, {
        id: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.attackDiscovery)
      }, {
        id: _securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings)
      }, _navigation_tree.defaultNavigationTree.cases()]
    }, {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.investigations(), {
        id: _securitySolutionNavigation.SecurityPageName.threatIntelligence,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.threatIntelligence)
      }, _navigation_tree.defaultNavigationTree.explore()]
    }, {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.assets(services), _navigation_tree.defaultNavigationTree.entityAnalytics()]
    }, _navigation_tree.defaultNavigationTree.ml()]
  }],
  footer: [{
    type: 'navItem',
    id: _securitySolutionNavigation.SecurityPageName.landing,
    link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
    icon: 'launch'
  }, {
    type: 'navItem',
    link: 'dev_tools',
    title: _links.i18nStrings.devTools,
    icon: 'editorCodeBlock'
  }, (0, _stack_management_navigation.createStackManagementNavigationTree)()]
});
exports.createNavigationTree = createNavigationTree;