"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.productTypes = exports.productType = exports.productTier = exports.productLine = exports.exposeToBrowser = exports.commonConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _product = require("./product");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const productLine = exports.productLine = _configSchema.schema.oneOf([_configSchema.schema.literal(_product.ProductLine.security), _configSchema.schema.literal(_product.ProductLine.endpoint), _configSchema.schema.literal(_product.ProductLine.cloud), _configSchema.schema.literal(_product.ProductLine.aiSoc)]);
const productTier = exports.productTier = _configSchema.schema.oneOf([_configSchema.schema.literal(_product.ProductTier.searchAiLake), _configSchema.schema.literal(_product.ProductTier.essentials), _configSchema.schema.literal(_product.ProductTier.complete)]);
const productType = exports.productType = _configSchema.schema.object({
  product_line: productLine,
  product_tier: productTier
});
const productTypes = exports.productTypes = _configSchema.schema.arrayOf(productType, {
  defaultValue: []
});
const commonConfigSchemaProps = {
  productTypes,
  /**
   * For internal use. A list of string values (comma delimited) that will enable experimental
   * type of functionality that is not yet released. Valid values for this settings need to
   * be defined in:
   * `x-pack/solutions/security/plugins/security_solution_serverless/common/experimental_features.ts`
   * under the `allowedExperimentalValues` object
   *
   * @example
   * xpack.securitySolutionServerless.enableExperimental:
   *   - someCrazyFeature
   *   - someEvenCrazierFeature
   */
  enableExperimental: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: () => []
  }),
  /**
   * A list of APP IDs that are not accessible in the serverless environment.
   * This is used to disable the apps in the UI and prevent users from accessing them.
   */
  inaccessibleApps: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  })
};
const commonConfigSchema = exports.commonConfigSchema = _configSchema.schema.object(commonConfigSchemaProps);
// This is used to expose the common config schema properties to the browser
// so that they can be used in the client-side code.
const exposeToBrowser = exports.exposeToBrowser = Object.fromEntries(Object.keys(commonConfigSchemaProps).map(prop => [prop, true]));