"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeoutCircuitBreaker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _perf_hooks = require("perf_hooks");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Configuration interface for Timeout Circuit Breaker.
 */

class TimeoutCircuitBreaker extends _utils.BaseCircuitBreaker {
  constructor(config) {
    super();
    (0, _defineProperty2.default)(this, "started", void 0);
    this.config = config;
    this.started = _perf_hooks.performance.now();
  }
  async validate() {
    const now = _perf_hooks.performance.now();
    if (now > this.started + this.config.timeoutMillis) {
      return this.failure(`Timeout exceeded: ${this.config.timeoutMillis.toString()} ms`);
    }
    return this.success();
  }
  stats() {
    return {
      started: this.started,
      elapsed: _perf_hooks.performance.now() - this.started
    };
  }
  validationIntervalMs() {
    return this.config.validationIntervalMs;
  }
}
exports.TimeoutCircuitBreaker = TimeoutCircuitBreaker;