"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertRuleToImportToRuleResponse = void 0;
var _uuid = require("uuid");
var _apply_rule_defaults = require("../../detection_rules_client/mergers/apply_rule_defaults");
var _detection_engine = require("../../../../../../../common/api/detection_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertRuleToImportToRuleResponse = ruleToImport => {
  const ruleResponseSpecificFields = {
    id: (0, _uuid.v4)(),
    updated_at: new Date().toISOString(),
    updated_by: '',
    created_at: new Date().toISOString(),
    created_by: '',
    revision: 1
  };
  const ruleWithDefaults = (0, _apply_rule_defaults.applyRuleDefaults)(ruleToImport);
  return _detection_engine.RuleResponse.parse({
    ...ruleResponseSpecificFields,
    ...ruleWithDefaults
  });
};
exports.convertRuleToImportToRuleResponse = convertRuleToImportToRuleResponse;