"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchTypeSpecificParams = exports.applyRulePatch = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _utils = require("../../../../../../../common/detection_engine/rule_management/utils");
var _rule_schema = require("../../../../../../../common/api/detection_engine/model/rule_schema");
var _utils2 = require("../../../../../../../common/detection_engine/utils");
var _utility_types = require("../../../../../../../common/utility_types");
var _calculate_rule_source = require("./rule_source/calculate_rule_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line complexity
const applyRulePatch = async ({
  rulePatch,
  existingRule,
  prebuiltRuleAssetClient
}) => {
  var _rulePatch$enabled, _rulePatch$name, _rulePatch$tags, _rulePatch$author, _rulePatch$building_b, _rulePatch$descriptio, _rulePatch$false_posi, _rulePatch$investigat, _rulePatch$from, _rulePatch$license, _rulePatch$output_ind, _rulePatch$alias_purp, _rulePatch$alias_targ, _rulePatch$timeline_i, _rulePatch$timeline_t, _rulePatch$meta, _rulePatch$max_signal, _rulePatch$related_in, _rulePatch$risk_score, _rulePatch$risk_score2, _rulePatch$rule_name_, _rulePatch$setup, _rulePatch$severity, _rulePatch$severity_m, _rulePatch$threat, _rulePatch$timestamp_, _rulePatch$timestamp_2, _rulePatch$to, _rulePatch$references, _rulePatch$namespace, _rulePatch$note, _rulePatch$version, _rulePatch$exceptions, _rulePatch$interval, _rulePatch$throttle, _rulePatch$actions, _rulePatch$response_a;
  const typeSpecificParams = patchTypeSpecificParams(rulePatch, existingRule);
  const nextRule = {
    // Keep existing values for these fields
    id: existingRule.id,
    rule_id: existingRule.rule_id,
    revision: existingRule.revision,
    immutable: existingRule.immutable,
    rule_source: existingRule.rule_source,
    updated_at: existingRule.updated_at,
    updated_by: existingRule.updated_by,
    created_at: existingRule.created_at,
    created_by: existingRule.created_by,
    // Update values for these fields
    enabled: (_rulePatch$enabled = rulePatch.enabled) !== null && _rulePatch$enabled !== void 0 ? _rulePatch$enabled : existingRule.enabled,
    name: (_rulePatch$name = rulePatch.name) !== null && _rulePatch$name !== void 0 ? _rulePatch$name : existingRule.name,
    tags: (_rulePatch$tags = rulePatch.tags) !== null && _rulePatch$tags !== void 0 ? _rulePatch$tags : existingRule.tags,
    author: (_rulePatch$author = rulePatch.author) !== null && _rulePatch$author !== void 0 ? _rulePatch$author : existingRule.author,
    building_block_type: (_rulePatch$building_b = rulePatch.building_block_type) !== null && _rulePatch$building_b !== void 0 ? _rulePatch$building_b : existingRule.building_block_type,
    description: (_rulePatch$descriptio = rulePatch.description) !== null && _rulePatch$descriptio !== void 0 ? _rulePatch$descriptio : existingRule.description,
    false_positives: (_rulePatch$false_posi = rulePatch.false_positives) !== null && _rulePatch$false_posi !== void 0 ? _rulePatch$false_posi : existingRule.false_positives,
    investigation_fields: (_rulePatch$investigat = rulePatch.investigation_fields) !== null && _rulePatch$investigat !== void 0 ? _rulePatch$investigat : existingRule.investigation_fields,
    from: (_rulePatch$from = rulePatch.from) !== null && _rulePatch$from !== void 0 ? _rulePatch$from : existingRule.from,
    license: (_rulePatch$license = rulePatch.license) !== null && _rulePatch$license !== void 0 ? _rulePatch$license : existingRule.license,
    output_index: (_rulePatch$output_ind = rulePatch.output_index) !== null && _rulePatch$output_ind !== void 0 ? _rulePatch$output_ind : existingRule.output_index,
    alias_purpose: (_rulePatch$alias_purp = rulePatch.alias_purpose) !== null && _rulePatch$alias_purp !== void 0 ? _rulePatch$alias_purp : existingRule.alias_purpose,
    alias_target_id: (_rulePatch$alias_targ = rulePatch.alias_target_id) !== null && _rulePatch$alias_targ !== void 0 ? _rulePatch$alias_targ : existingRule.alias_target_id,
    timeline_id: (_rulePatch$timeline_i = rulePatch.timeline_id) !== null && _rulePatch$timeline_i !== void 0 ? _rulePatch$timeline_i : existingRule.timeline_id,
    timeline_title: (_rulePatch$timeline_t = rulePatch.timeline_title) !== null && _rulePatch$timeline_t !== void 0 ? _rulePatch$timeline_t : existingRule.timeline_title,
    meta: (_rulePatch$meta = rulePatch.meta) !== null && _rulePatch$meta !== void 0 ? _rulePatch$meta : existingRule.meta,
    max_signals: (_rulePatch$max_signal = rulePatch.max_signals) !== null && _rulePatch$max_signal !== void 0 ? _rulePatch$max_signal : existingRule.max_signals,
    related_integrations: (_rulePatch$related_in = rulePatch.related_integrations) !== null && _rulePatch$related_in !== void 0 ? _rulePatch$related_in : existingRule.related_integrations,
    required_fields: rulePatch.required_fields ? (0, _utils.addEcsToRequiredFields)(rulePatch.required_fields) : existingRule.required_fields,
    risk_score: (_rulePatch$risk_score = rulePatch.risk_score) !== null && _rulePatch$risk_score !== void 0 ? _rulePatch$risk_score : existingRule.risk_score,
    risk_score_mapping: (_rulePatch$risk_score2 = rulePatch.risk_score_mapping) !== null && _rulePatch$risk_score2 !== void 0 ? _rulePatch$risk_score2 : existingRule.risk_score_mapping,
    rule_name_override: (_rulePatch$rule_name_ = rulePatch.rule_name_override) !== null && _rulePatch$rule_name_ !== void 0 ? _rulePatch$rule_name_ : existingRule.rule_name_override,
    setup: (_rulePatch$setup = rulePatch.setup) !== null && _rulePatch$setup !== void 0 ? _rulePatch$setup : existingRule.setup,
    severity: (_rulePatch$severity = rulePatch.severity) !== null && _rulePatch$severity !== void 0 ? _rulePatch$severity : existingRule.severity,
    severity_mapping: (_rulePatch$severity_m = rulePatch.severity_mapping) !== null && _rulePatch$severity_m !== void 0 ? _rulePatch$severity_m : existingRule.severity_mapping,
    threat: (_rulePatch$threat = rulePatch.threat) !== null && _rulePatch$threat !== void 0 ? _rulePatch$threat : existingRule.threat,
    timestamp_override: (_rulePatch$timestamp_ = rulePatch.timestamp_override) !== null && _rulePatch$timestamp_ !== void 0 ? _rulePatch$timestamp_ : existingRule.timestamp_override,
    timestamp_override_fallback_disabled: (_rulePatch$timestamp_2 = rulePatch.timestamp_override_fallback_disabled) !== null && _rulePatch$timestamp_2 !== void 0 ? _rulePatch$timestamp_2 : existingRule.timestamp_override_fallback_disabled,
    to: (_rulePatch$to = rulePatch.to) !== null && _rulePatch$to !== void 0 ? _rulePatch$to : existingRule.to,
    references: (_rulePatch$references = rulePatch.references) !== null && _rulePatch$references !== void 0 ? _rulePatch$references : existingRule.references,
    namespace: (_rulePatch$namespace = rulePatch.namespace) !== null && _rulePatch$namespace !== void 0 ? _rulePatch$namespace : existingRule.namespace,
    note: (_rulePatch$note = rulePatch.note) !== null && _rulePatch$note !== void 0 ? _rulePatch$note : existingRule.note,
    version: (_rulePatch$version = rulePatch.version) !== null && _rulePatch$version !== void 0 ? _rulePatch$version : existingRule.version,
    exceptions_list: (_rulePatch$exceptions = rulePatch.exceptions_list) !== null && _rulePatch$exceptions !== void 0 ? _rulePatch$exceptions : existingRule.exceptions_list,
    interval: (_rulePatch$interval = rulePatch.interval) !== null && _rulePatch$interval !== void 0 ? _rulePatch$interval : existingRule.interval,
    throttle: (_rulePatch$throttle = rulePatch.throttle) !== null && _rulePatch$throttle !== void 0 ? _rulePatch$throttle : existingRule.throttle,
    actions: (_rulePatch$actions = rulePatch.actions) !== null && _rulePatch$actions !== void 0 ? _rulePatch$actions : existingRule.actions,
    response_actions: (_rulePatch$response_a = rulePatch.response_actions) !== null && _rulePatch$response_a !== void 0 ? _rulePatch$response_a : existingRule.response_actions,
    ...typeSpecificParams
  };
  nextRule.rule_source = await (0, _calculate_rule_source.calculateRuleSource)({
    nextRule,
    currentRule: existingRule,
    prebuiltRuleAssetClient
  });
  return nextRule;
};
exports.applyRulePatch = applyRulePatch;
const patchEqlParams = (rulePatch, existingRule) => {
  var _rulePatch$language, _rulePatch$index, _rulePatch$data_view_, _rulePatch$query, _rulePatch$filters, _rulePatch$timestamp_3, _rulePatch$event_cate, _rulePatch$tiebreaker, _rulePatch$alert_supp;
  return {
    type: existingRule.type,
    language: (_rulePatch$language = rulePatch.language) !== null && _rulePatch$language !== void 0 ? _rulePatch$language : existingRule.language,
    index: (_rulePatch$index = rulePatch.index) !== null && _rulePatch$index !== void 0 ? _rulePatch$index : existingRule.index,
    data_view_id: (_rulePatch$data_view_ = rulePatch.data_view_id) !== null && _rulePatch$data_view_ !== void 0 ? _rulePatch$data_view_ : existingRule.data_view_id,
    query: (_rulePatch$query = rulePatch.query) !== null && _rulePatch$query !== void 0 ? _rulePatch$query : existingRule.query,
    filters: (_rulePatch$filters = rulePatch.filters) !== null && _rulePatch$filters !== void 0 ? _rulePatch$filters : existingRule.filters,
    timestamp_field: (_rulePatch$timestamp_3 = rulePatch.timestamp_field) !== null && _rulePatch$timestamp_3 !== void 0 ? _rulePatch$timestamp_3 : existingRule.timestamp_field,
    event_category_override: (_rulePatch$event_cate = rulePatch.event_category_override) !== null && _rulePatch$event_cate !== void 0 ? _rulePatch$event_cate : existingRule.event_category_override,
    tiebreaker_field: (_rulePatch$tiebreaker = rulePatch.tiebreaker_field) !== null && _rulePatch$tiebreaker !== void 0 ? _rulePatch$tiebreaker : existingRule.tiebreaker_field,
    alert_suppression: (_rulePatch$alert_supp = rulePatch.alert_suppression) !== null && _rulePatch$alert_supp !== void 0 ? _rulePatch$alert_supp : existingRule.alert_suppression
  };
};
const patchEsqlParams = (rulePatch, existingRule) => {
  var _rulePatch$language2, _rulePatch$query2, _rulePatch$alert_supp2;
  return {
    type: existingRule.type,
    language: (_rulePatch$language2 = rulePatch.language) !== null && _rulePatch$language2 !== void 0 ? _rulePatch$language2 : existingRule.language,
    query: (_rulePatch$query2 = rulePatch.query) !== null && _rulePatch$query2 !== void 0 ? _rulePatch$query2 : existingRule.query,
    alert_suppression: (_rulePatch$alert_supp2 = rulePatch.alert_suppression) !== null && _rulePatch$alert_supp2 !== void 0 ? _rulePatch$alert_supp2 : existingRule.alert_suppression
  };
};
const patchThreatMatchParams = (rulePatch, existingRule) => {
  var _rulePatch$language3, _rulePatch$index2, _rulePatch$data_view_2, _rulePatch$query3, _rulePatch$filters2, _rulePatch$saved_id, _rulePatch$threat_fil, _rulePatch$threat_que, _rulePatch$threat_map, _rulePatch$threat_lan, _rulePatch$threat_ind, _rulePatch$threat_ind2, _rulePatch$concurrent, _rulePatch$items_per_, _rulePatch$alert_supp3;
  return {
    type: existingRule.type,
    language: (_rulePatch$language3 = rulePatch.language) !== null && _rulePatch$language3 !== void 0 ? _rulePatch$language3 : existingRule.language,
    index: (_rulePatch$index2 = rulePatch.index) !== null && _rulePatch$index2 !== void 0 ? _rulePatch$index2 : existingRule.index,
    data_view_id: (_rulePatch$data_view_2 = rulePatch.data_view_id) !== null && _rulePatch$data_view_2 !== void 0 ? _rulePatch$data_view_2 : existingRule.data_view_id,
    query: (_rulePatch$query3 = rulePatch.query) !== null && _rulePatch$query3 !== void 0 ? _rulePatch$query3 : existingRule.query,
    filters: (_rulePatch$filters2 = rulePatch.filters) !== null && _rulePatch$filters2 !== void 0 ? _rulePatch$filters2 : existingRule.filters,
    saved_id: (_rulePatch$saved_id = rulePatch.saved_id) !== null && _rulePatch$saved_id !== void 0 ? _rulePatch$saved_id : existingRule.saved_id,
    threat_filters: (_rulePatch$threat_fil = rulePatch.threat_filters) !== null && _rulePatch$threat_fil !== void 0 ? _rulePatch$threat_fil : existingRule.threat_filters,
    threat_query: (_rulePatch$threat_que = rulePatch.threat_query) !== null && _rulePatch$threat_que !== void 0 ? _rulePatch$threat_que : existingRule.threat_query,
    threat_mapping: (_rulePatch$threat_map = rulePatch.threat_mapping) !== null && _rulePatch$threat_map !== void 0 ? _rulePatch$threat_map : existingRule.threat_mapping,
    threat_language: (_rulePatch$threat_lan = rulePatch.threat_language) !== null && _rulePatch$threat_lan !== void 0 ? _rulePatch$threat_lan : existingRule.threat_language,
    threat_index: (_rulePatch$threat_ind = rulePatch.threat_index) !== null && _rulePatch$threat_ind !== void 0 ? _rulePatch$threat_ind : existingRule.threat_index,
    threat_indicator_path: (_rulePatch$threat_ind2 = rulePatch.threat_indicator_path) !== null && _rulePatch$threat_ind2 !== void 0 ? _rulePatch$threat_ind2 : existingRule.threat_indicator_path,
    concurrent_searches: (_rulePatch$concurrent = rulePatch.concurrent_searches) !== null && _rulePatch$concurrent !== void 0 ? _rulePatch$concurrent : existingRule.concurrent_searches,
    items_per_search: (_rulePatch$items_per_ = rulePatch.items_per_search) !== null && _rulePatch$items_per_ !== void 0 ? _rulePatch$items_per_ : existingRule.items_per_search,
    alert_suppression: (_rulePatch$alert_supp3 = rulePatch.alert_suppression) !== null && _rulePatch$alert_supp3 !== void 0 ? _rulePatch$alert_supp3 : existingRule.alert_suppression
  };
};
const patchQueryParams = (rulePatch, existingRule) => {
  var _rulePatch$language4, _rulePatch$index3, _rulePatch$data_view_3, _rulePatch$query4, _rulePatch$filters3, _rulePatch$saved_id2, _rulePatch$alert_supp4;
  return {
    type: existingRule.type,
    language: (_rulePatch$language4 = rulePatch.language) !== null && _rulePatch$language4 !== void 0 ? _rulePatch$language4 : existingRule.language,
    index: (_rulePatch$index3 = rulePatch.index) !== null && _rulePatch$index3 !== void 0 ? _rulePatch$index3 : existingRule.index,
    data_view_id: (_rulePatch$data_view_3 = rulePatch.data_view_id) !== null && _rulePatch$data_view_3 !== void 0 ? _rulePatch$data_view_3 : existingRule.data_view_id,
    query: (_rulePatch$query4 = rulePatch.query) !== null && _rulePatch$query4 !== void 0 ? _rulePatch$query4 : existingRule.query,
    filters: (_rulePatch$filters3 = rulePatch.filters) !== null && _rulePatch$filters3 !== void 0 ? _rulePatch$filters3 : existingRule.filters,
    saved_id: (_rulePatch$saved_id2 = rulePatch.saved_id) !== null && _rulePatch$saved_id2 !== void 0 ? _rulePatch$saved_id2 : existingRule.saved_id,
    alert_suppression: (_rulePatch$alert_supp4 = rulePatch.alert_suppression) !== null && _rulePatch$alert_supp4 !== void 0 ? _rulePatch$alert_supp4 : existingRule.alert_suppression
  };
};
const patchSavedQueryParams = (rulePatch, existingRule) => {
  var _rulePatch$language5, _rulePatch$index4, _rulePatch$data_view_4, _rulePatch$query5, _rulePatch$filters4, _rulePatch$saved_id3, _rulePatch$alert_supp5;
  return {
    type: existingRule.type,
    language: (_rulePatch$language5 = rulePatch.language) !== null && _rulePatch$language5 !== void 0 ? _rulePatch$language5 : existingRule.language,
    index: (_rulePatch$index4 = rulePatch.index) !== null && _rulePatch$index4 !== void 0 ? _rulePatch$index4 : existingRule.index,
    data_view_id: (_rulePatch$data_view_4 = rulePatch.data_view_id) !== null && _rulePatch$data_view_4 !== void 0 ? _rulePatch$data_view_4 : existingRule.data_view_id,
    query: (_rulePatch$query5 = rulePatch.query) !== null && _rulePatch$query5 !== void 0 ? _rulePatch$query5 : existingRule.query,
    filters: (_rulePatch$filters4 = rulePatch.filters) !== null && _rulePatch$filters4 !== void 0 ? _rulePatch$filters4 : existingRule.filters,
    saved_id: (_rulePatch$saved_id3 = rulePatch.saved_id) !== null && _rulePatch$saved_id3 !== void 0 ? _rulePatch$saved_id3 : existingRule.saved_id,
    alert_suppression: (_rulePatch$alert_supp5 = rulePatch.alert_suppression) !== null && _rulePatch$alert_supp5 !== void 0 ? _rulePatch$alert_supp5 : existingRule.alert_suppression
  };
};
const patchThresholdParams = (rulePatch, existingRule) => {
  var _rulePatch$language6, _rulePatch$index5, _rulePatch$data_view_5, _rulePatch$query6, _rulePatch$filters5, _rulePatch$saved_id4, _rulePatch$alert_supp6;
  return {
    type: existingRule.type,
    language: (_rulePatch$language6 = rulePatch.language) !== null && _rulePatch$language6 !== void 0 ? _rulePatch$language6 : existingRule.language,
    index: (_rulePatch$index5 = rulePatch.index) !== null && _rulePatch$index5 !== void 0 ? _rulePatch$index5 : existingRule.index,
    data_view_id: (_rulePatch$data_view_5 = rulePatch.data_view_id) !== null && _rulePatch$data_view_5 !== void 0 ? _rulePatch$data_view_5 : existingRule.data_view_id,
    query: (_rulePatch$query6 = rulePatch.query) !== null && _rulePatch$query6 !== void 0 ? _rulePatch$query6 : existingRule.query,
    filters: (_rulePatch$filters5 = rulePatch.filters) !== null && _rulePatch$filters5 !== void 0 ? _rulePatch$filters5 : existingRule.filters,
    saved_id: (_rulePatch$saved_id4 = rulePatch.saved_id) !== null && _rulePatch$saved_id4 !== void 0 ? _rulePatch$saved_id4 : existingRule.saved_id,
    threshold: rulePatch.threshold ? (0, _utils2.normalizeThresholdObject)(rulePatch.threshold) : existingRule.threshold,
    alert_suppression: (_rulePatch$alert_supp6 = rulePatch.alert_suppression) !== null && _rulePatch$alert_supp6 !== void 0 ? _rulePatch$alert_supp6 : existingRule.alert_suppression
  };
};
const patchMachineLearningParams = (params, existingRule) => {
  var _params$anomaly_thres, _params$alert_suppres;
  return {
    type: existingRule.type,
    anomaly_threshold: (_params$anomaly_thres = params.anomaly_threshold) !== null && _params$anomaly_thres !== void 0 ? _params$anomaly_thres : existingRule.anomaly_threshold,
    machine_learning_job_id: params.machine_learning_job_id ? (0, _utils2.normalizeMachineLearningJobIds)(params.machine_learning_job_id) : existingRule.machine_learning_job_id,
    alert_suppression: (_params$alert_suppres = params.alert_suppression) !== null && _params$alert_suppres !== void 0 ? _params$alert_suppres : existingRule.alert_suppression
  };
};
const patchNewTermsParams = (params, existingRule) => {
  var _params$language, _params$index, _params$data_view_id, _params$query, _params$filters, _params$new_terms_fie, _params$history_windo, _params$alert_suppres2;
  return {
    type: existingRule.type,
    language: (_params$language = params.language) !== null && _params$language !== void 0 ? _params$language : existingRule.language,
    index: (_params$index = params.index) !== null && _params$index !== void 0 ? _params$index : existingRule.index,
    data_view_id: (_params$data_view_id = params.data_view_id) !== null && _params$data_view_id !== void 0 ? _params$data_view_id : existingRule.data_view_id,
    query: (_params$query = params.query) !== null && _params$query !== void 0 ? _params$query : existingRule.query,
    filters: (_params$filters = params.filters) !== null && _params$filters !== void 0 ? _params$filters : existingRule.filters,
    new_terms_fields: (_params$new_terms_fie = params.new_terms_fields) !== null && _params$new_terms_fie !== void 0 ? _params$new_terms_fie : existingRule.new_terms_fields,
    history_window_start: (_params$history_windo = params.history_window_start) !== null && _params$history_windo !== void 0 ? _params$history_windo : existingRule.history_window_start,
    alert_suppression: (_params$alert_suppres2 = params.alert_suppression) !== null && _params$alert_suppres2 !== void 0 ? _params$alert_suppres2 : existingRule.alert_suppression
  };
};
const patchTypeSpecificParams = (params, existingRule) => {
  // Here we do the validation of patch params by rule type to ensure that the fields that are
  // passed in to patch are of the correct type, e.g. `query` is a string. Since the combined patch schema
  // is a union of types where everything is optional, it's hard to do the validation before we know the rule type -
  // a patch request that defines `event_category_override` as a number would not be assignable to the EQL patch schema,
  // but would be assignable to the other rule types since they don't specify `event_category_override`.
  switch (existingRule.type) {
    case 'eql':
      {
        const result = _rule_schema.EqlRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchEqlParams(result.data, existingRule);
      }
    case 'esql':
      {
        const result = _rule_schema.EsqlRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchEsqlParams(result.data, existingRule);
      }
    case 'threat_match':
      {
        const result = _rule_schema.ThreatMatchRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchThreatMatchParams(result.data, existingRule);
      }
    case 'query':
      {
        const result = _rule_schema.QueryRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchQueryParams(result.data, existingRule);
      }
    case 'saved_query':
      {
        const result = _rule_schema.SavedQueryRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchSavedQueryParams(result.data, existingRule);
      }
    case 'threshold':
      {
        const result = _rule_schema.ThresholdRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchThresholdParams(result.data, existingRule);
      }
    case 'machine_learning':
      {
        const result = _rule_schema.MachineLearningRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchMachineLearningParams(result.data, existingRule);
      }
    case 'new_terms':
      {
        const result = _rule_schema.NewTermsRulePatchFields.safeParse(params);
        if (!result.success) {
          throw new _securitysolutionEsUtils.BadRequestError((0, _zodHelpers.stringifyZodError)(result.error));
        }
        return patchNewTermsParams(result.data, existingRule);
      }
    default:
      {
        return (0, _utility_types.assertUnreachable)(existingRule);
      }
  }
};
exports.patchTypeSpecificParams = patchTypeSpecificParams;