"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefendInsightsPrompt = getDefendInsightsPrompt;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _errors = require("../errors");
var _incompatible_antivirus = require("./incompatible_antivirus");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefendInsightsPrompt({
  type,
  events
}) {
  if (type === _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus) {
    return (0, _incompatible_antivirus.getIncompatibleAntivirusPrompt)({
      events
    });
  }
  throw new _errors.InvalidDefendInsightTypeError();
}