"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedFieldValue = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _types = require("../../../../../../common/entity_analytics/types");
var _get_agent_type_for_agent_id_field = require("../../../../../common/lib/endpoint/utils/get_agent_type_for_agent_id_field");
var _field_names = require("../../../../../../common/field_maps/field_names");
var _agent_status = require("../../../../../common/components/endpoint/agents/agent_status");
var _constants = require("../../../../../../common/cti/constants");
var _bytes = require("./bytes");
var _duration = require("../../../duration");
var _empty_value = require("../../../../../common/components/empty_value");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _formatted_ip = require("../../../formatted_ip");
var _port = require("../../../../../explore/network/components/port");
var _helpers = require("../../../../../explore/network/components/port/helpers");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _constants2 = require("./constants");
var _formatted_field_helpers = require("./formatted_field_helpers");
var _rule_status = require("./rule_status");
var _host_name = require("./host_name");
var _user_name = require("./user_name");
var _asset_criticality_level = require("./asset_criticality_level");
var _service_name = require("./service_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

// Offset top-aligned tooltips so that cell actions are more visible
const dataGridToolTipOffset = (0, _react2.css)`
  &[data-position='top'] {
    margin-block-start: -8px;
  }
`;
const FormattedFieldValueComponent = ({
  asPlainText,
  Component,
  contextId,
  eventId,
  fieldFormat,
  isAggregatable = false,
  isUnifiedDataTable,
  fieldName,
  fieldType = '',
  fieldFromBrowserField,
  isButton,
  isObjectArray = false,
  onClick,
  onClickAriaLabel,
  title,
  truncate = true,
  value,
  linkValue
}) => {
  if (isObjectArray || asPlainText) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `formatted-field-${fieldName}`
    }, value);
  } else if (fieldType === _constants2.IP_FIELD_TYPE) {
    return /*#__PURE__*/_react.default.createElement(_formatted_ip.FormattedIp, {
      Component: Component,
      fieldName: fieldName,
      isButton: isButton,
      value: !(0, _fp.isNumber)(value) ? value : String(value),
      onClick: onClick,
      title: title
    });
  } else if (fieldType === _constants2.GEO_FIELD_TYPE) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
  } else if (fieldType === _constants2.DATE_FIELD_TYPE) {
    const classNames = truncate ? 'eui-textTruncate' : undefined;
    const date = /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      className: classNames,
      fieldName: fieldName,
      value: value,
      tooltipProps: isUnifiedDataTable ? undefined : {
        position: 'bottom',
        css: dataGridToolTipOffset
      }
    });
    if (isUnifiedDataTable) return date;
    return date;
  } else if (_helpers.PORT_NAMES.some(portName => fieldName === portName)) {
    return /*#__PURE__*/_react.default.createElement(_port.Port, {
      Component: Component,
      title: title,
      value: `${value}`
    });
  } else if (fieldName === _duration.EVENT_DURATION_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_duration.Duration, {
      fieldName: fieldName,
      value: `${value}`
    });
  } else if (fieldName === _types.EntityTypeToIdentifierField.host) {
    return /*#__PURE__*/_react.default.createElement(_host_name.HostName, {
      Component: Component,
      contextId: contextId,
      isButton: isButton,
      onClick: onClick,
      title: title,
      value: value
    });
  } else if (fieldName === _types.EntityTypeToIdentifierField.user) {
    return /*#__PURE__*/_react.default.createElement(_user_name.UserName, {
      Component: Component,
      contextId: contextId,
      isButton: isButton,
      onClick: onClick,
      title: title,
      value: value
    });
  } else if (fieldName === _types.EntityTypeToIdentifierField.service) {
    return /*#__PURE__*/_react.default.createElement(_service_name.ServiceName, {
      Component: Component,
      contextId: contextId,
      isButton: isButton,
      onClick: onClick,
      title: title,
      value: value
    });
  } else if (fieldFormat === _bytes.BYTES_FORMAT) {
    return /*#__PURE__*/_react.default.createElement(_bytes.Bytes, {
      value: `${value}`
    });
  } else if (fieldName === _constants2.SIGNAL_RULE_NAME_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_formatted_field_helpers.RenderRuleName, {
      Component: Component,
      fieldName: fieldName,
      isButton: isButton,
      onClick: onClick,
      linkValue: linkValue,
      title: title,
      truncate: truncate,
      value: value
    });
  } else if (fieldName === _constants2.EVENT_MODULE_FIELD_NAME) {
    return (0, _formatted_field_helpers.renderEventModule)({
      linkValue,
      truncate,
      value
    });
  } else if (fieldName === _constants2.SIGNAL_STATUS_FIELD_NAME) {
    return /*#__PURE__*/_react.default.createElement(_rule_status.RuleStatus, {
      value: value,
      onClick: onClick,
      onClickAriaLabel: onClickAriaLabel,
      iconType: isButton ? 'arrowDown' : undefined,
      iconSide: isButton ? 'right' : undefined
    });
  } else if (fieldName === _field_names.ALERT_HOST_CRITICALITY || fieldName === _field_names.ALERT_USER_CRITICALITY || fieldName === _field_names.ALERT_SERVICE_CRITICALITY) {
    return /*#__PURE__*/_react.default.createElement(_asset_criticality_level.AssetCriticalityLevel, {
      value: value
    });
  } else if (fieldName === _constants2.AGENT_STATUS_FIELD_NAME) {
    var _fieldFromBrowserFiel;
    return /*#__PURE__*/_react.default.createElement(_agent_status.AgentStatus, {
      agentId: String(value !== null && value !== void 0 ? value : ''),
      agentType: (0, _get_agent_type_for_agent_id_field.getAgentTypeForAgentIdField)((_fieldFromBrowserFiel = fieldFromBrowserField === null || fieldFromBrowserField === void 0 ? void 0 : fieldFromBrowserField.name) !== null && _fieldFromBrowserFiel !== void 0 ? _fieldFromBrowserFiel : ''),
      "data-test-subj": "endpointHostAgentStatus"
    });
  } else if ([_constants2.RULE_REFERENCE_FIELD_NAME, _constants2.REFERENCE_URL_FIELD_NAME, _constants2.EVENT_URL_FIELD_NAME, _constants.INDICATOR_REFERENCE].includes(fieldName)) {
    return (0, _formatted_field_helpers.renderUrl)({
      Component,
      truncate,
      title,
      value
    });
  } else {
    return truncate && !(0, _fp.isEmpty)(value) ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
      "data-test-subj": "truncatable-message"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "message-tool-tip",
      position: "bottom",
      css: dataGridToolTipOffset,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, value)))
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `formatted-field-${fieldName}`
    }, value))) : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `formatted-field-${fieldName}`
    }, (0, _empty_value.getOrEmptyTagFromValue)(value));
  }
};
const FormattedFieldValue = exports.FormattedFieldValue = /*#__PURE__*/_react.default.memo(FormattedFieldValueComponent);