"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFleetManagedIndexTemplates = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFleetManagedIndexTemplates = async http => {
  try {
    const indexTemplatesGetResponse = await http.get(_constants.SECRUTIY_INTEGRATIONS_FLEET_MANAGED_INDEX_TEMPLATES_URL, {
      version: '1'
    });
    return {
      indexTemplates: indexTemplatesGetResponse
    };
  } catch (e) {
    var _e$response;
    if (((_e$response = e.response) === null || _e$response === void 0 ? void 0 : _e$response.status) === 403) {
      return {
        indexTemplates: [],
        permissionsError: true
      };
    }
    return {
      indexTemplates: [],
      generalError: true
    };
  }
};
exports.getFleetManagedIndexTemplates = getFleetManagedIndexTemplates;