"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkGetAgentPolicies = useBulkGetAgentPolicies;
exports.useEndpointPackagePoliciesStats = useEndpointPackagePoliciesStats;
exports.useGetEndpointSecurityPackage = useGetEndpointSecurityPackage;
exports.useGetEndpointSpecificPolicies = useGetEndpointSpecificPolicies;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _constants = require("../../../../common/endpoint/constants");
var _kibana = require("../../../common/lib/kibana");
var _constants2 = require("../../common/constants");
var _ingest = require("./ingest");
var _policies = require("./policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// FIXME:PT move to `hooks` folder
function useGetEndpointSpecificPolicies({
  onError,
  page,
  perPage
} = {
  page: 1,
  perPage: _constants2.MANAGEMENT_DEFAULT_PAGE_SIZE
}) {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['endpointSpecificPolicies', page, perPage], () => {
    return (0, _policies.sendGetEndpointSpecificPackagePolicies)(http, {
      query: {
        page,
        perPage,
        withAgentCount: true
      }
    });
  }, onError ? {
    onError
  } : undefined);
}
function useEndpointPackagePoliciesStats(enabled) {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(['endpointPackagePoliciesStatsStrategy'], async () => {
    return (0, _rxjs.firstValueFrom)(data.search.search({}, {
      strategy: _constants.ENDPOINT_PACKAGE_POLICIES_STATS_STRATEGY
    }));
  }, {
    select: response => response.rawResponse,
    enabled
  });
}

/**
 * This hook returns the endpoint security package which contains endpoint version info
 */
function useGetEndpointSecurityPackage({
  customQueryOptions
}) {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['endpointPackageVersion', customQueryOptions], () => {
    return (0, _ingest.sendGetEndpointSecurityPackage)(http);
  }, customQueryOptions);
}
function useBulkGetAgentPolicies({
  isEnabled,
  policyIds
}) {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['agentPolicies', policyIds], async () => {
    var _await$sendBulkGetAge;
    if (!policyIds.length) {
      return [];
    }
    return (_await$sendBulkGetAge = await (0, _ingest.sendBulkGetAgentPolicies)({
      http,
      requestBody: {
        ids: policyIds
      }
    })) === null || _await$sendBulkGetAge === void 0 ? void 0 : _await$sendBulkGetAge.items;
  }, {
    enabled: isEnabled,
    refetchOnWindowFocus: false,
    retry: 1
  });
}