"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchOngoingScans = void 0;
var _reactQuery = require("@tanstack/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = require("react");
var _translations = require("../../translations");
var _kibana = require("../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchOngoingScans = ({
  isPolling,
  endpointId,
  onSuccess
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const toasts = (0, _kibana.useToasts)();

  // Ref to track if polling was active in the previous render
  const wasPolling = (0, _react.useRef)(isPolling);
  (0, _react.useEffect)(() => {
    // If polling was active and isPolling is false, it means the condition has been met and we can run onSuccess logic (i.e. refetch insights)
    if (wasPolling.current && !isPolling) {
      onSuccess();
    }
    wasPolling.current = isPolling;
  }, [isPolling, onSuccess]);
  return (0, _reactQuery.useQuery)([`fetchOngoingTasks-${endpointId}`], async () => {
    try {
      const response = await http.get(_elasticAssistantCommon.DEFEND_INSIGHTS, {
        version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
        query: {
          status: _elasticAssistantCommon.DefendInsightStatusEnum.running,
          endpoint_ids: [endpointId]
        }
      });
      return response.data;
    } catch (error) {
      var _error$body;
      toasts.addDanger({
        title: _translations.WORKFLOW_INSIGHTS.toasts.fetchPendingInsightsError,
        text: error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error
      });
      return [];
    }
  }, {
    refetchOnWindowFocus: false,
    refetchInterval: isPolling ? 2000 : false
  });
};
exports.useFetchOngoingScans = useFetchOngoingScans;