"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldFormat = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the format of a given field.
 *
 * Due to compatibility issues we may see the format as either string (legacy) or the SerializedFieldFormat object (modernized)
 * value. This helper extracts the correct one.
 */
const getFieldFormat = field => {
  var _field$format;
  return typeof (field === null || field === void 0 ? void 0 : field.format) === 'string' ? field.format : field === null || field === void 0 ? void 0 : (_field$format = field.format) === null || _field$format === void 0 ? void 0 : _field$format.id;
};
exports.getFieldFormat = getFieldFormat;