"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewRule = void 0;
var _react = require("react");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _kibana = require("../../../../common/lib/kibana");
var _api = require("../../../rule_management/api/api");
var _transforms = require("../../../../detections/containers/detection_engine/rules/transforms");
var _use_preview_invocation_count = require("./use_preview_invocation_count");
var i18n = _interopRequireWildcard(require("./translations"));
var _telemetry = require("../../../../common/lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyPreviewRule = {
  previewId: undefined,
  logs: [],
  isAborted: false
};
const usePreviewRule = ({
  timeframeOptions,
  enableLoggedRequests
}) => {
  const [rule, setRule] = (0, _react.useState)(null);
  const [response, setResponse] = (0, _react.useState)(emptyPreviewRule);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    invocationCount,
    interval,
    from
  } = (0, _use_preview_invocation_count.usePreviewInvocationCount)({
    timeframeOptions
  });
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const timeframeEnd = (0, _react.useMemo)(() => timeframeOptions.timeframeEnd.toISOString(), [timeframeOptions]);
  (0, _react.useEffect)(() => {
    if (!rule) {
      setResponse(emptyPreviewRule);
      setIsLoading(false);
    }
  }, [rule]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    setResponse(emptyPreviewRule);
    const createPreviewId = async () => {
      if (rule != null) {
        try {
          telemetry.reportEvent(_telemetry.PreviewRuleEventTypes.PreviewRule, {
            loggedRequestsEnabled: enableLoggedRequests !== null && enableLoggedRequests !== void 0 ? enableLoggedRequests : false,
            ruleType: rule.type
          });
          setIsLoading(true);
          const previewRuleResponse = await (0, _api.previewRule)({
            rule: {
              ...(0, _transforms.transformOutput)({
                ...rule,
                interval,
                from
              }),
              invocationCount,
              timeframeEnd
            },
            enableLoggedRequests,
            signal: abortCtrl.signal
          });
          if (isSubscribed) {
            setResponse(previewRuleResponse);
          }
        } catch (error) {
          if (isSubscribed) {
            addError(error, {
              title: i18n.RULE_PREVIEW_ERROR
            });
          }
        }
        if (isSubscribed) {
          setIsLoading(false);
        }
      }
    };
    createPreviewId();
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [rule, addError, invocationCount, from, interval, timeframeEnd, enableLoggedRequests, telemetry]);
  return {
    isLoading,
    response,
    rule,
    setRule
  };
};
exports.usePreviewRule = usePreviewRule;