"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResolveRedirect = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _rison = require("@kbn/rison");
var _use_selector = require("./use_selector");
var _timeline = require("../../../common/types/timeline");
var _store = require("../../timelines/store");
var _defaults = require("../../timelines/store/defaults");
var _kibana = require("../lib/kibana");
var _use_url_state = require("./use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hooks is specifically for use with the resolve api that was introduced as part of 7.16
 * If a deep link id has been migrated to a new id, this hook will cause a redirect to a url with
 * the new ID.
 */

const useResolveRedirect = () => {
  const {
    search,
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const [hasRedirected, updateHasRedirected] = (0, _react.useState)(false);
  const {
    spaces
  } = (0, _kibana.useKibana)().services;
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    resolveTimelineConfig,
    savedObjectId,
    show,
    activeTab,
    graphEventId
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, _timeline.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
  });
  const redirect = (0, _react.useCallback)(() => {
    var _searchQuery$get, _ref, _resolveTimelineConfi;
    const searchQuery = new URLSearchParams(search);
    const timelineRison = (_searchQuery$get = searchQuery.get(_use_url_state.URL_PARAM_KEY.timeline)) !== null && _searchQuery$get !== void 0 ? _searchQuery$get : undefined;

    // Try to get state on URL, but default to what's in Redux in case of decodeRisonFailure
    const currentTimelineState = {
      id: savedObjectId !== null && savedObjectId !== void 0 ? savedObjectId : '',
      isOpen: !!show,
      activeTab,
      graphEventId
    };
    const timelineSearch = (_ref = (0, _rison.safeDecode)(timelineRison !== null && timelineRison !== void 0 ? timelineRison : '')) !== null && _ref !== void 0 ? _ref : currentTimelineState;
    if (hasRedirected || !spaces || (resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.outcome) !== 'aliasMatch' || (resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.alias_target_id) == null) {
      return null;
    }

    // We found this object by a legacy URL alias from its old ID; redirect the user to the page with its new ID, preserving any URL hash
    const newObjectId = (_resolveTimelineConfi = resolveTimelineConfig.alias_target_id) !== null && _resolveTimelineConfi !== void 0 ? _resolveTimelineConfi : ''; // This is always defined if outcome === 'aliasMatch'
    const newTimelineSearch = {
      ...timelineSearch,
      id: newObjectId
    };
    const newTimelineRison = (0, _rison.encode)(newTimelineSearch);
    searchQuery.set(_use_url_state.URL_PARAM_KEY.timeline, newTimelineRison);
    const newPath = `${pathname}?${searchQuery.toString()}`;
    spaces.ui.redirectLegacyUrl({
      path: newPath,
      aliasPurpose: resolveTimelineConfig.alias_purpose,
      objectNoun: _use_url_state.URL_PARAM_KEY.timeline
    });
    // Prevent the effect from being called again as the url change takes place in location rather than a true redirect
    updateHasRedirected(true);
  }, [activeTab, graphEventId, hasRedirected, pathname, resolveTimelineConfig, savedObjectId, search, show, spaces]);
  (0, _react.useEffect)(() => {
    redirect();
  }, [redirect]);
};
exports.useResolveRedirect = useResolveRedirect;