"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmValidationErrorsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmValidationErrorsModal = exports.ConfirmValidationErrorsModal = /*#__PURE__*/(0, _react.memo)(function ConfirmValidationErrorsModal({
  errors,
  onCancel,
  onConfirm
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "save-with-errors-confirmation-modal",
    title: i18n.SAVE_WITH_ERRORS_MODAL_TITLE,
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: i18n.CANCEL,
    confirmButtonText: i18n.CONFIRM,
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SAVE_WITH_ERRORS_MESSAGE(errors.length), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", null, errors.map(error => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, error));
  }))));
});