"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyTableProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_installed_security_jobs = require("../hooks/use_installed_security_jobs");
var _use_anomalies_table_data = require("./use_anomalies_table_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyTableProvider = exports.AnomalyTableProvider = /*#__PURE__*/_react.default.memo(({
  influencers,
  startDate,
  endDate,
  children,
  criteriaFields,
  skip
}) => {
  const {
    jobNameById
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobNameById)();
  const jobIds = (0, _react.useMemo)(() => Object.keys(jobNameById), [jobNameById]);
  const [isLoadingAnomaliesData, anomaliesData] = (0, _use_anomalies_table_data.useAnomaliesTableData)({
    criteriaFields,
    influencers,
    startDate,
    endDate,
    skip,
    jobIds,
    aggregationInterval: 'auto'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }));
});
AnomalyTableProvider.displayName = 'AnomalyTableProvider';