"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INTEGRATION_SECTION_LABEL = exports.AgentTypeIntegration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _is_agent_type_in_tech_preview = require("../../../../../../common/endpoint/service/response_actions/is_agent_type_in_tech_preview");
var _use_test_id_generator = require("../../../../../management/hooks/use_test_id_generator");
var _agent_type_vendor_logo = require("../agent_type_vendor_logo");
var _translations = require("../../../../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_SECTION_LABEL = exports.INTEGRATION_SECTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.agentTypeIntegration.integrationSectionLabel', {
  defaultMessage: 'Integration'
});

/**
 * Shows the vendor Icon and name associated with an agent type
 */

const AgentTypeIntegration = exports.AgentTypeIntegration = /*#__PURE__*/(0, _react.memo)(({
  agentType,
  textSize = 's',
  layout = 'vertical',
  'data-test-subj': dataTestSubj
}) => {
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isTechPreview = (0, _react.useMemo)(() => {
    return (0, _is_agent_type_in_tech_preview.isAgentTypeInTechPreview)(agentType);
  }, [agentType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: layout === 'horizontal' ? 'row' : 'column',
    gutterSize: "s",
    "data-test-subj": testId()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: textSize,
    "data-test-subj": testId('label')
  }, INTEGRATION_SECTION_LABEL, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.responder.header.integrationSectionLabelTooltip",
      defaultMessage: "The integration used to execute response actions on this host"
    }),
    position: layout === 'horizontal' ? 'bottom' : 'right',
    anchorProps: {
      'data-test-subj': testId('tooltipAnchor')
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_agent_type_vendor_logo.AgentTypeVendorLogo, {
    agentType: agentType,
    "data-test-subj": testId('vendorLogo')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    "data-test-subj": testId('name')
  }, (0, _translations.getAgentTypeName)(agentType))), isTechPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations.TECHNICAL_PREVIEW,
    tooltipContent: _translations.TECHNICAL_PREVIEW_TOOLTIP,
    iconType: "beaker",
    size: "s",
    "data-test-subj": testId('betaBadge')
  })))));
});
AgentTypeIntegration.displayName = 'AgentTypeIntegration';