"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseOrThrowErrorFactory = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const throwErrors = createError => errors => {
  throw createError((0, _zodHelpers.stringifyZodError)(errors));
};
const parseRuntimeType = zodType => v => {
  const result = zodType.safeParse(v);
  return result.success ? (0, _Either.right)(result.data) : (0, _Either.left)(result.error);
};
const parseOrThrowErrorFactory = createError => runtimeType => inputValue => (0, _pipeable.pipe)(parseRuntimeType(runtimeType)(inputValue), (0, _Either.fold)(throwErrors(createError), _function.identity));
exports.parseOrThrowErrorFactory = parseOrThrowErrorFactory;