"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleCustomizationStatus = exports.PrebuiltRulesFilter = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleCustomizationStatus = exports.RuleCustomizationStatus = /*#__PURE__*/function (RuleCustomizationStatus) {
  RuleCustomizationStatus["CUSTOMIZED"] = "CUSTOMIZED";
  RuleCustomizationStatus["NOT_CUSTOMIZED"] = "NOT_CUSTOMIZED";
  return RuleCustomizationStatus;
}({});
const PrebuiltRulesFilter = exports.PrebuiltRulesFilter = _zod.z.object({
  /**
   * Tags to filter by
   */
  tags: _zod.z.array(_zod.z.string()).optional(),
  /**
   * Rule name to filter by
   */
  name: _zod.z.string().optional(),
  /**
   * Rule customization status to filter by
   */
  customization_status: _zod.z.nativeEnum(RuleCustomizationStatus).optional()
});