"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRulesPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRulesPageTemplate = ({
  children,
  ...props
}) => {
  const {
    services: {
      console: consolePlugin,
      history,
      searchNavigation
    }
  } = (0, _use_kibana.useKibana)();
  const embeddedConsole = _react.default.useMemo(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, null) : null, [consolePlugin]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, (0, _extends2.default)({
    offset: 0,
    restrictWidth: true,
    grow: false,
    "data-test-subj": "queryRulesBasePage",
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    color: "primary"
  }, props), children, embeddedConsole);
};
exports.QueryRulesPageTemplate = QueryRulesPageTemplate;