"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleStreamResponse = void 0;
var _stream_factory = require("./stream_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleStreamResponse = async ({
  stream,
  request,
  response,
  logger,
  isCloud = false
}) => {
  const {
    end,
    push,
    responseWithHeaders
  } = (0, _stream_factory.streamFactory)(logger, isCloud);
  const reader = stream.getReader();
  const abortController = new AbortController();
  request.events.aborted$.subscribe(() => {
    abortController.abort();
  });
  request.events.completed$.subscribe(() => {
    abortController.abort();
  });
  async function pushStreamUpdate() {
    try {
      const {
        done,
        value
      } = await reader.read();
      if (done || abortController.signal.aborted) {
        end();
        return;
      }
      if (value) push(value);
      void pushStreamUpdate();
    } catch (error) {
      logger.error(`Error occurred while pushing the next chunk: ${error.toString()}`);
      end();
      abortController.abort();
      throw error;
    }
  }
  try {
    void pushStreamUpdate();
  } catch (error) {
    logger.error('Failed to push stream update', error);
    throw error;
  }
  return response.ok(responseWithHeaders);
};
exports.handleStreamResponse = handleStreamResponse;