"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkDeleteAction = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBulkDeleteAction = ({
  overlays,
  notifications,
  tagClient,
  setLoading
}) => {
  return {
    id: 'delete',
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.management.actions.bulkDelete.label', {
      defaultMessage: 'Delete'
    }),
    'aria-label': _i18n.i18n.translate('xpack.savedObjectsTagging.management.actions.bulkDelete.ariaLabel', {
      defaultMessage: 'Delete selected tags'
    }),
    icon: 'trash',
    refreshAfterExecute: true,
    execute: async tagIds => {
      const confirmed = await overlays.openConfirm(_i18n.i18n.translate('xpack.savedObjectsTagging.management.actions.bulkDelete.confirm.text', {
        defaultMessage: 'By deleting {count, plural, one {this tag} other {these tags}}, you will no longer be able to assign {count, plural, one {it} other {them}} to saved objects. ' + '{count, plural, one {This tag} other {These tags}} will be removed from any saved objects that currently use {count, plural, one {it} other {them}}.',
        values: {
          count: tagIds.length
        }
      }), {
        title: _i18n.i18n.translate('xpack.savedObjectsTagging.management.actions.bulkDelete.confirm.title', {
          defaultMessage: 'Delete {count, plural, one {1 tag} other {# tags}}',
          values: {
            count: tagIds.length
          }
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.savedObjectsTagging.management.actions.bulkDelete.confirm.confirmButtonText', {
          defaultMessage: 'Delete {count, plural, one {tag} other {tags}}',
          values: {
            count: tagIds.length
          }
        }),
        buttonColor: 'danger',
        maxWidth: 560
      });
      if (confirmed) {
        setLoading(true);
        await tagClient.bulkDelete(tagIds);
        setLoading(false);
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.savedObjectsTagging.management.actions.bulkDelete.notification.successTitle', {
            defaultMessage: 'Deleted {count, plural, one {1 tag} other {# tags}}',
            values: {
              count: tagIds.length
            }
          })
        });
      }
    }
  };
};
exports.getBulkDeleteAction = getBulkDeleteAction;