"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allIndices = void 0;
exports.getIndicesInfo = getIndicesInfo;
exports.getIndicesLifecycleStatus = getIndicesLifecycleStatus;
exports.getIndicesStats = getIndicesStats;
exports.getNodesStats = getNodesStats;
exports.symbolsIndices = exports.stacktracesIndices = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const symbolsIndices = exports.symbolsIndices = ['profiling-symbols-global', 'profiling-symbols-private', 'profiling-executables', 'profiling-stackframes', 'profiling-returnpads-private'];
const stacktracesIndices = exports.stacktracesIndices = ['profiling-events-*', 'profiling-metrics', 'profiling-stacktraces', 'profiling-executables', 'profiling-stackframes'];
const allIndices = exports.allIndices = ['profiling-events-*', 'profiling-metrics', 'profiling-stacktraces', 'profiling-sq-executables', 'profiling-sq-leafframes', 'profiling-hosts', 'profiling-symbols-global', 'profiling-symbols-private', 'profiling-executables', 'profiling-stackframes', 'profiling-returnpads-private'];
function getIndicesStats({
  client,
  indices
}) {
  return client.indices.stats({
    index: indices.join(),
    expand_wildcards: 'all'
  });
}
function getIndicesInfo({
  client,
  indices
}) {
  return client.indices.get({
    index: indices.join(),
    filter_path: ['*.settings.index.number_of_shards', '*.settings.index.number_of_replicas', '*.data_stream'],
    features: ['settings'],
    expand_wildcards: 'all'
  });
}
async function getIndicesLifecycleStatus({
  client,
  indices
}) {
  const ilmLifecycle = await client.ilm.explainLifecycle({
    index: indices.join(),
    filter_path: 'indices.*.phase'
  });
  return ilmLifecycle.indices;
}
function getNodesStats({
  client
}) {
  return client.nodes.stats({
    metric: 'fs',
    filter_path: 'nodes.*.fs.total.total_in_bytes'
  });
}