"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSharedFields = exports.getRelatedAlertKuery = exports.SQS_QUEUES = exports.SERVICE_NAME = exports.S3_BUCKETS = exports.RDS_DATABASES = exports.OBSERVER_NAME = exports.MONITOR_ID = exports.KUBERNETES_POD = exports.HOST = exports.EC2_INSTANCE = exports.DOCKER_CONTAINER = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// APM rules
const SERVICE_NAME = exports.SERVICE_NAME = 'service.name';
// Synthetics rules
const MONITOR_ID = exports.MONITOR_ID = 'monitor.id';
// - location
const OBSERVER_NAME = exports.OBSERVER_NAME = 'observer.name';
// Inventory rule
const HOST = exports.HOST = 'host.name';
const KUBERNETES_POD = exports.KUBERNETES_POD = 'kubernetes.pod.uid';
const DOCKER_CONTAINER = exports.DOCKER_CONTAINER = 'container.id';
const EC2_INSTANCE = exports.EC2_INSTANCE = 'cloud.instance.id';
const S3_BUCKETS = exports.S3_BUCKETS = 'aws.s3.bucket.name';
const RDS_DATABASES = exports.RDS_DATABASES = 'aws.rds.db_instance.arn';
const SQS_QUEUES = exports.SQS_QUEUES = 'aws.sqs.queue.name';
const ALL_SHARED_FIELDS = [SERVICE_NAME, MONITOR_ID, OBSERVER_NAME, HOST, KUBERNETES_POD, DOCKER_CONTAINER, EC2_INSTANCE, S3_BUCKETS, RDS_DATABASES, SQS_QUEUES];
const getSharedFields = (alertFields = {}) => {
  const matchedFields = [];
  ALL_SHARED_FIELDS.forEach(source => {
    Object.keys(alertFields).forEach(field => {
      if (source === field) {
        const fieldValue = alertFields[field];
        matchedFields.push({
          name: source,
          value: Array.isArray(fieldValue) ? fieldValue[0] : fieldValue
        });
      }
    });
  });
  return matchedFields;
};
exports.getSharedFields = getSharedFields;
const EXCLUDE_TAGS = ['apm'];
const getRelatedAlertKuery = ({
  tags,
  groups,
  ruleId,
  sharedFields
} = {}) => {
  var _tags$filter$map, _ref, _ref2, _groups$map, _sharedFields$filter$;
  const tagKueries = (_tags$filter$map = tags === null || tags === void 0 ? void 0 : tags.filter(tag => !EXCLUDE_TAGS.includes(tag)).map(tag => {
    return `tags: "${tag}"`;
  })) !== null && _tags$filter$map !== void 0 ? _tags$filter$map : [];
  const groupKueries = (_ref = groups && groups.map(({
    field,
    value
  }) => {
    return `(${field}: "${value}" or kibana.alert.group.value: "${value}")`;
  })) !== null && _ref !== void 0 ? _ref : [];
  const ruleKueries = (_ref2 = ruleId && [`(${_ruleDataUtils.ALERT_RULE_UUID}: "${ruleId}")`]) !== null && _ref2 !== void 0 ? _ref2 : [];
  const groupFields = (_groups$map = groups === null || groups === void 0 ? void 0 : groups.map(group => group.field)) !== null && _groups$map !== void 0 ? _groups$map : [];
  const sharedFieldsKueries = (_sharedFields$filter$ = sharedFields === null || sharedFields === void 0 ? void 0 : sharedFields.filter(field => !groupFields.includes(field.name)).map(field => {
    return `(${field.name}: "${field.value}")`;
  })) !== null && _sharedFields$filter$ !== void 0 ? _sharedFields$filter$ : [];
  const tagKueriesStr = tagKueries.length > 0 ? [`(${tagKueries.join(' or ')})`] : [];
  const groupKueriesStr = groupKueries.length > 0 ? [`${groupKueries.join(' or ')}`] : [];
  const kueries = [...tagKueriesStr, ...groupKueriesStr, ...sharedFieldsKueries, ...ruleKueries];
  return kueries.length ? kueries.join(' or ') : undefined;
};
exports.getRelatedAlertKuery = getRelatedAlertKuery;