"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const config = exports.config = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  scope: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('observability'), _configSchema.schema.literal('search')])),
  enableKnowledgeBase: _configSchema.schema.boolean({
    defaultValue: true
  }),
  disableKbSemanticTextMigration: _configSchema.schema.boolean({
    defaultValue: false
  })
});