"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _reactQuery = require("@tanstack/react-query");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _config = require("./routes/config");
var _redirect_to_home_if_unauthorized = require("./routes/components/redirect_to_home_if_unauthorized");
var _app_context = require("./context/app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mountManagementSection = async ({
  core,
  mountParams,
  config
}) => {
  const [coreStart, startDeps] = await core.getStartServices();
  if (!startDeps.observabilityAIAssistant) return () => {};
  const {
    element,
    history,
    setBreadcrumbs
  } = mountParams;
  const {
    theme$
  } = core.theme;
  coreStart.chrome.docTitle.change(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.app.titleBar', {
    defaultMessage: 'AI Assistant for Observability and Search Settings'
  }));
  const queryClient = new _reactQuery.QueryClient();
  _reactDom.default.render((0, _public.wrapWithTheme)(/*#__PURE__*/_react.default.createElement(_redirect_to_home_if_unauthorized.RedirectToHomeIfUnauthorized, {
    coreStart: coreStart
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...startDeps
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: {
      setBreadcrumbs,
      config
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.aIAssistantManagementObservabilityRouter
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, null))))))), theme$), element);
  return () => {
    coreStart.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountManagementSection = mountManagementSection;