"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.List = void 0;
var _flatten_pipeline_section = require("./flatten_pipeline_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class List {
  constructor(inputs, filters, outputs, queue) {
    this.inputs = inputs;
    this.filters = filters;
    this.outputs = outputs;
    this.queue = queue;
  }
  static fromPipeline(pipeline) {
    const {
      inputStatements,
      filterStatements,
      outputStatements,
      queue
    } = pipeline;
    return new List((0, _flatten_pipeline_section.flattenPipelineSection)(inputStatements), (0, _flatten_pipeline_section.flattenPipelineSection)(filterStatements), (0, _flatten_pipeline_section.flattenPipelineSection)(outputStatements), queue);
  }
}
exports.List = List;