"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextClassificationOutputComponent = exports.TextClassificationOutput = exports.PredictionProbabilityList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTextClassificationOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(TextClassificationOutput, {
  inferrer: inferrer
});
exports.getTextClassificationOutputComponent = getTextClassificationOutputComponent;
const TextClassificationOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, result.map(({
    response,
    inputText
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(PredictionProbabilityList, {
    response: response,
    inputText: inputText
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))));
};
exports.TextClassificationOutput = TextClassificationOutput;
const PredictionProbabilityList = ({
  response,
  inputText
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inputText !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, inputText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, response.map(({
    value,
    predictionProbability
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: value
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: predictionProbability * 100,
    max: 100,
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `mlTestModelLangIdentInputValue`
  }, value), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `mlTestModelLangIdentInputProbability`,
    grow: false
  }, predictionProbability)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
};
exports.PredictionProbabilityList = PredictionProbabilityList;