"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataMappingPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

class DataMappingPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  _renderButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this._togglePopover,
      size: "xs",
      iconType: "controlsHorizontal",
      iconSide: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.styles.fieldMetaOptions.popoverToggle",
      defaultMessage: "Data mapping"
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "dataMappingPopover",
      anchorPosition: "leftCenter",
      button: this._renderButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      ownFocus: true
    }, this.props.children);
  }
}
exports.DataMappingPopover = DataMappingPopover;