"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.focusNextElement = exports.disableEventDefaults = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disableEventDefaults = event => {
  event.preventDefault();
  event.stopPropagation();
};
exports.disableEventDefaults = disableEventDefaults;
const focusNextElement = (event, selector, direction) => {
  const list = Array.from(document.querySelectorAll(selector));
  const currentIndex = list.indexOf(event.currentTarget);
  if (currentIndex > -1) {
    const nextButton = list[currentIndex + (direction === 'next' ? +1 : -1)];
    if (nextButton) {
      disableEventDefaults(event);
      nextButton.focus();
    }
  }
};
exports.focusNextElement = focusNextElement;