"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerationModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_generation = require("./use_generation");
var _error_with_link = require("./error_with_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const progressText = {
  analyzeLogs: i18n.PROGRESS_ANALYZE_LOGS,
  ecs: i18n.PROGRESS_ECS_MAPPING,
  categorization: i18n.PROGRESS_CATEGORIZATION,
  related: i18n.PROGRESS_RELATED_GRAPH
};
const useModalCss = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    headerCss: (0, _react2.css)`
      justify-content: center;
      margin-top: ${euiTheme.size.m};
    `,
    bodyCss: (0, _react2.css)`
      padding: ${euiTheme.size.xxxxl};
      min-width: 600px;
    `
  };
};
const GenerationModal = exports.GenerationModal = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  connector,
  onComplete,
  onClose
}) => {
  const {
    headerCss,
    bodyCss
  } = useModalCss();
  const {
    progress,
    error,
    retry
  } = (0, _use_generation.useGeneration)({
    integrationSettings,
    connector,
    onComplete
  });
  const progressValue = (0, _react.useMemo)(() => progress ? _use_generation.ProgressOrder.indexOf(progress) + 1 : 0, [progress]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "generationModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    css: headerCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.ANALYZING)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    css: bodyCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    justifyContent: "center"
  }, progress && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.GENERATION_ERROR_TITLE(progressText[progress]),
    color: "danger",
    iconType: "alert",
    "data-test-subj": "generationErrorCallout"
  }, /*#__PURE__*/_react.default.createElement(_error_with_link.ErrorMessage, {
    error: error
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, progressText[progress])))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: progressValue,
    max: 4,
    color: "primary",
    size: "m"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "refresh",
    onClick: retry,
    "data-test-subj": "retryButton"
  }, i18n.RETRY))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })));
});
GenerationModal.displayName = 'GenerationModal';