"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Tabs = ({
  onTabChange,
  selectedTab
}) => {
  const tabs = [{
    id: 'documents',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.tabs.documentsTabTitle",
      defaultMessage: "Documents"
    })
  }, {
    id: 'output',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.tabs.outputTabTitle",
      defaultMessage: "Output"
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onTabChange(tab.id),
    isSelected: tab.id === selectedTab,
    key: tab.id,
    "data-test-subj": tab.id.toLowerCase() + 'Tab'
  }, tab.name)));
};
exports.Tabs = Tabs;