"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLConfigurationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MLConfigurationPanel = ({
  isLoading,
  readOnly,
  anomalyThresholdFieldProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.mlSectionTitle",
    defaultMessage: "Machine Learning"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.anomalyThresholdTitle",
      defaultMessage: "Anomaly Severity Threshold"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.anomalyThresholdDescription",
      defaultMessage: "Sets the minimum severity score required to show anomalies in the Metrics application."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: anomalyThresholdFieldProps.error,
    fullWidth: true,
    isInvalid: anomalyThresholdFieldProps.isInvalid,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.anomalyThresholdLabel",
      defaultMessage: "Minimum severity score"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, (0, _extends2.default)({
    min: 0,
    max: 100,
    "data-test-subj": "anomalyThresholdInput",
    showInput: true,
    showTicks: true,
    showRange: true,
    tickInterval: 20,
    "aria-label": "Minimum severity score",
    disabled: isLoading,
    readOnly: readOnly,
    isLoading: isLoading
  }, anomalyThresholdFieldProps)))));
};
exports.MLConfigurationPanel = MLConfigurationPanel;