"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATE_ORDER = exports.STATE_NAMES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATE_NAMES = exports.STATE_NAMES = {
  running: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.stateRunning', {
    defaultMessage: 'Running'
  }),
  sleeping: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.stateSleeping', {
    defaultMessage: 'Sleeping'
  }),
  dead: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.stateDead', {
    defaultMessage: 'Dead'
  }),
  stopped: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.stateStopped', {
    defaultMessage: 'Stopped'
  }),
  idle: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.stateIdle', {
    defaultMessage: 'Idle'
  }),
  zombie: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.stateZombie', {
    defaultMessage: 'Zombie'
  }),
  unknown: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.stateUnknown', {
    defaultMessage: 'Unknown'
  })
};
const STATE_ORDER = exports.STATE_ORDER = ['running', 'sleeping', 'stopped', 'idle', 'dead', 'zombie', 'unknown'];