"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COMPLETION_TASK_TYPE = void 0;
exports.isSupportedConnector = isSupportedConnector;
exports.isSupportedConnectorType = isSupportedConnectorType;
var _connectors = require("./connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMPLETION_TASK_TYPE = exports.COMPLETION_TASK_TYPE = 'chat_completion';

/**
 * Checks if a given connector type is compatible for inference.
 *
 * Note: this check is not sufficient to assert if a given connector can be
 * used for inference, as `.inference` connectors need additional check logic.
 * Please use `isSupportedConnector` instead when possible.
 */
function isSupportedConnectorType(id) {
  return _connectors.allSupportedConnectorTypes.includes(id);
}

/**
 * Checks if a given connector is compatible for inference.
 *
 * A connector is compatible if:
 * 1. its type is in the list of allowed types
 * 2. for inference connectors, if its taskType is "chat_completion"
 */
function isSupportedConnector(connector) {
  if (!isSupportedConnectorType(connector.actionTypeId)) {
    return false;
  }
  if (connector.actionTypeId === _connectors.InferenceConnectorType.Inference) {
    var _connector$config;
    const config = (_connector$config = connector.config) !== null && _connector$config !== void 0 ? _connector$config : {};
    // only chat_completion endpoint can be used for inference
    if (config.taskType !== COMPLETION_TASK_TYPE) {
      return false;
    }
  }
  return true;
}