"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../../../common/constants");
var _app_context = require("../../../app_context");
var _api = require("../../../services/api");
var _breadcrumbs = require("../../../services/breadcrumbs");
var _documentation = require("../../../services/documentation");
var _data_stream_table = require("./data_stream_table");
var _data_stream_detail_panel = require("./data_stream_detail_panel");
var _data_streams = require("../../../lib/data_streams");
var _use_state_with_localstorage = require("../../../hooks/use_state_with_localstorage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_PROJECT_LEVEL_RETENTION = 'showProjectLevelRetention';
const DataStreamList = ({
  match: {
    params: {
      dataStreamName
    }
  },
  location: {
    search
  },
  history
}) => {
  const {
    isDeepLink,
    includeHidden
  } = (0, _shared_imports.extractQueryParams)(search);
  const decodedDataStreamName = (0, _shared_imports.attemptToURIDecode)(dataStreamName);
  const {
    config: {
      enableProjectLevelRetentionChecks
    },
    core: {
      getUrlForApp,
      executionContext
    },
    plugins: {
      isFleetEnabled,
      cloud
    }
  } = (0, _app_context.useAppContext)();
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'indexManagementDataStreamsTab'
  });
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.dataStreams);
  }, []);
  const [isIncludeStatsChecked, setIsIncludeStatsChecked] = (0, _react.useState)(false);
  const {
    error,
    isLoading,
    data: dataStreams,
    resendRequest: reload
  } = (0, _api.useLoadDataStreams)({
    includeStats: isIncludeStatsChecked
  });
  const [projectLevelRetentionCallout, setprojectLevelRetentionCallout] = (0, _use_state_with_localstorage.useStateWithLocalStorage)(SHOW_PROJECT_LEVEL_RETENTION, true);
  const [filters, setFilters] = (0, _react.useState)({
    managed: {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.viewManagedLabel', {
        defaultMessage: 'Managed data streams'
      }),
      checked: 'on'
    },
    hidden: {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.viewHiddenLabel', {
        defaultMessage: 'Hidden data streams'
      }),
      checked: includeHidden ? 'on' : 'off'
    }
  });
  const activateHiddenFilter = shouldBeActive => {
    if (shouldBeActive && filters.hidden.checked === 'off') {
      setFilters({
        ...filters,
        hidden: {
          ...filters.hidden,
          checked: 'on'
        }
      });
    }
  };
  const filteredDataStreams = (0, _react.useMemo)(() => {
    if (!dataStreams) {
      // If dataStreams are not fetched, return empty array.
      return [];
    }
    const visibleTypes = Object.entries(filters).filter(([name, _filter]) => _filter.checked === 'on').map(([name]) => name);
    return (0, _data_streams.filterDataStreams)(dataStreams, visibleTypes);
  }, [dataStreams, filters]);
  const renderHeader = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      css: {
        maxWidth: '80%'
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.dataStreamsDescription",
      defaultMessage: "Data streams store time-series data across multiple indices and can be created from index templates. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getDataStreamsDocumentationLink(),
          target: "_blank",
          external: true
        }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamListDescription.learnMoreLinkText', {
          defaultMessage: 'Learn more.'
        }))
      }
    }))), enableProjectLevelRetentionChecks && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: cloud === null || cloud === void 0 ? void 0 : cloud.deploymentUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.projectlevelRetention.linkText",
      defaultMessage: "Project data retention"
    }))));
  };
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.loadingDataStreamsDescription",
      defaultMessage: "Loading data streams\u2026"
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.loadingDataStreamsErrorMessage",
        defaultMessage: "Error loading data streams"
      }),
      error: error
    });
  } else if (Array.isArray(dataStreams) && dataStreams.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": "title"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsTitle",
        defaultMessage: "You don't have any data streams yet"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsDescription",
        defaultMessage: "Data streams store time-series data across multiple indices."
      }), ' ' /* We need this space to separate these two sentences. */, isFleetEnabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaFleetMessage",
        defaultMessage: "Get started with data streams in {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "dataStreamsEmptyPromptTemplateLink",
            href: getUrlForApp('fleet')
          }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaFleetLink', {
            defaultMessage: 'Fleet'
          }))
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaIndexTemplateMessage",
        defaultMessage: "Get started with data streams by creating a {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
            "data-test-subj": "dataStreamsEmptyPromptTemplateLink"
          }, (0, _shared_imports.reactRouterNavigate)(history, {
            pathname: '/templates'
          })), _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.emptyPrompt.noDataStreamsCtaIndexTemplateLink', {
            defaultMessage: 'composable index template'
          }))
        }
      })),
      "data-test-subj": "emptyPrompt"
    });
  } else {
    activateHiddenFilter((0, _data_streams.isSelectedDataStreamHidden)(dataStreams, decodedDataStreamName));
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      paddingSize: "none",
      "data-test-subj": "dataStreamList"
    }, enableProjectLevelRetentionChecks && projectLevelRetentionCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      onDismiss: () => setprojectLevelRetentionCallout(false),
      "data-test-subj": "projectLevelRetentionCallout",
      title: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.projectLevelRetentionCallout.titleText', {
        defaultMessage: 'You can now configure data stream retention settings for your entire project'
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.projectLevelRetentionCallout.descriptionText",
      defaultMessage: "Optionally define a maximum and default retention period to manage your compliance and storage size needs."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: cloud === null || cloud === void 0 ? void 0 : cloud.deploymentUrl,
      fill: true,
      "data-test-subj": "cloudLinkButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.projectLevelRetentionCallout.buttonText",
      defaultMessage: "Get started"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), renderHeader(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_data_stream_table.DataStreamTable, {
      filters: isDeepLink && decodedDataStreamName !== undefined ? `name="${decodedDataStreamName}"` : '',
      dataStreams: filteredDataStreams,
      reload: reload,
      viewFilters: filters,
      onViewFilterChange: setFilters,
      history: history,
      includeStats: isIncludeStatsChecked,
      setIncludeStats: setIsIncludeStatsChecked
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _shared_imports.APP_WRAPPER_CLASS
  }, content, decodedDataStreamName && /*#__PURE__*/_react.default.createElement(_data_stream_detail_panel.DataStreamDetailPanel, {
    dataStreamName: decodedDataStreamName,
    onClose: shouldReload => {
      history.push(`/${_constants.Section.DataStreams}`);

      // If the data stream was deleted, we need to refresh the list.
      if (shouldReload) {
        reload();
      }
    }
  }));
};
exports.DataStreamList = DataStreamList;