"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Synopsis = Synopsis;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Synopsis({
  id,
  description,
  iconUrl,
  iconType,
  title,
  url,
  onClick,
  isBeta
}) {
  let optionalImg;
  if (iconUrl) {
    optionalImg = /*#__PURE__*/_react.default.createElement("img", {
      alt: "",
      className: "synopsisIcon",
      src: iconUrl
    });
  } else if (iconType) {
    optionalImg = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "text",
      size: "l",
      title: "",
      type: iconType
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    betaBadgeProps: {
      label: isBeta ? 'Beta' : null
    },
    className: "homSynopsis__card",
    "data-test-subj": `homeSynopsisLink${id.toLowerCase()}`,
    description: description,
    href: url,
    icon: optionalImg,
    layout: "horizontal",
    onClick: onClick,
    title: title,
    titleElement: "h3",
    titleSize: "xs"
  });
}
Synopsis.propTypes = {
  description: _propTypes.default.string.isRequired,
  iconUrl: _propTypes.default.string,
  iconType: _propTypes.default.string,
  title: _propTypes.default.string.isRequired,
  url: _propTypes.default.string,
  onClick: _propTypes.default.func,
  isBeta: _propTypes.default.bool
};
Synopsis.defaultProps = {
  isBeta: false
};