"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkplaceSearchUnconfigured = exports.WorkplaceSearchConfiguredRoutes = exports.WorkplaceSearchConfigured = exports.WorkplaceSearch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _is_version_mismatch = require("../../../common/is_version_mismatch");
var _http = require("../shared/http");
var _kibana = require("../shared/kibana");
var _version_mismatch = require("../shared/version_mismatch");
var _app_logic = require("./app_logic");
var _layout = require("./components/layout");
var _routes = require("./routes");
var _account_settings = require("./views/account_settings");
var _api_keys = require("./views/api_keys");
var _content_sources = require("./views/content_sources");
var _source_added = require("./views/content_sources/components/source_added");
var _error_state = require("./views/error_state");
var _groups = require("./views/groups");
var _not_found = require("./views/not_found");
var _oauth_authorize = require("./views/oauth_authorize");
var _overview = require("./views/overview");
var _role_mappings = require("./views/role_mappings");
var _search_authorize = require("./views/search_authorize");
var _security = require("./views/security");
var _settings = require("./views/settings");
var _setup_guide = require("./views/setup_guide");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkplaceSearch = props => {
  const {
    config
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    enterpriseSearchVersion,
    kibanaVersion
  } = props;
  const incompatibleVersions = (0, _is_version_mismatch.isVersionMismatch)(enterpriseSearchVersion, kibanaVersion);
  const isSetupGuidePath = !!(0, _reactRouterDom.useRouteMatch)(_routes.SETUP_GUIDE_PATH);
  if (!config.host) {
    return /*#__PURE__*/_react.default.createElement(WorkplaceSearchUnconfigured, null);
  } else if (incompatibleVersions) {
    return /*#__PURE__*/_react.default.createElement(_version_mismatch.VersionMismatchPage, {
      enterpriseSearchVersion: enterpriseSearchVersion,
      kibanaVersion: kibanaVersion
    });
  } else if (errorConnectingMessage && !isSetupGuidePath) {
    return /*#__PURE__*/_react.default.createElement(_error_state.ErrorState, null);
  }
  return /*#__PURE__*/_react.default.createElement(WorkplaceSearchConfigured, props);
};
exports.WorkplaceSearch = WorkplaceSearch;
const WorkplaceSearchConfiguredRoutes = ({
  isAdmin,
  kibanaUIsEnabled
}) => {
  const isblockingRoutes = isAdmin && !kibanaUIsEnabled;
  return !isblockingRoutes ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_overview.Overview, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SETUP_GUIDE_PATH
  }, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuide, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SOURCE_ADDED_PATH
  }, /*#__PURE__*/_react.default.createElement(_source_added.SourceAdded, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.PERSONAL_PATH
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: _routes.PERSONAL_PATH,
    to: _routes.PRIVATE_SOURCES_PATH
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.PRIVATE_SOURCES_PATH
  }, /*#__PURE__*/_react.default.createElement(_content_sources.SourcesRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.PERSONAL_SETTINGS_PATH
  }, /*#__PURE__*/_react.default.createElement(_account_settings.AccountSettings, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.OAUTH_AUTHORIZE_PATH
  }, /*#__PURE__*/_react.default.createElement(_oauth_authorize.OAuthAuthorize, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_AUTHORIZE_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_authorize.SearchAuthorize, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, {
    isOrganization: false
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SOURCES_PATH
  }, /*#__PURE__*/_react.default.createElement(_content_sources.SourcesRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.GROUPS_PATH
  }, /*#__PURE__*/_react.default.createElement(_groups.GroupsRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.USERS_AND_ROLES_PATH
  }, /*#__PURE__*/_react.default.createElement(_role_mappings.RoleMappings, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.API_KEYS_PATH
  }, /*#__PURE__*/_react.default.createElement(_api_keys.ApiKeys, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SECURITY_PATH
  }, /*#__PURE__*/_react.default.createElement(_security.Security, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ORG_SETTINGS_PATH
  }, /*#__PURE__*/_react.default.createElement(_settings.SettingsRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, null))) : /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_overview.Overview, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, null)));
};
exports.WorkplaceSearchConfiguredRoutes = WorkplaceSearchConfiguredRoutes;
const WorkplaceSearchConfigured = props => {
  const {
    hasInitialized,
    organization: {
      kibanaUIsEnabled
    },
    account: {
      isAdmin
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    initializeAppData,
    setContext
  } = (0, _kea.useActions)(_app_logic.AppLogic);
  const {
    renderHeaderActions,
    setChromeIsVisible
  } = (0, _kea.useValues)(_kibana.KibanaLogic);

  /**
   * Personal dashboard urls begin with /p/
   * EX: http://localhost:5601/app/enterprise_search/workplace_search/p/sources
   */
  const isOrganization = !(0, _reactRouterDom.useRouteMatch)(_routes.PERSONAL_PATH);
  setContext(isOrganization);
  (0, _react.useEffect)(() => {
    setChromeIsVisible(isOrganization);
  }, [isOrganization]);
  (0, _react.useEffect)(() => {
    if (!hasInitialized) {
      initializeAppData(props);
      renderHeaderActions(_layout.WorkplaceSearchHeaderActions);
    }
  }, [hasInitialized]);
  return /*#__PURE__*/_react.default.createElement(WorkplaceSearchConfiguredRoutes, {
    isAdmin: isAdmin,
    kibanaUIsEnabled: kibanaUIsEnabled
  });
};
exports.WorkplaceSearchConfigured = WorkplaceSearchConfigured;
const WorkplaceSearchUnconfigured = () => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: _routes.SETUP_GUIDE_PATH
}, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuide, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  to: _routes.SETUP_GUIDE_PATH
})));
exports.WorkplaceSearchUnconfigured = WorkplaceSearchUnconfigured;