"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupGuideCta = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _constants = require("../../constants");
var _getting_started = _interopRequireDefault(require("./assets/getting_started.png"));
require("./setup_guide_cta.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupGuideCta = () => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiPanelTo, {
  to: "/setup_guide",
  paddingSize: "l",
  className: "enterpriseSearchSetupCta",
  "data-test-subj": "setupGuideLink",
  hasBorder: true,
  color: "transparent"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h2", null, _constants.PRODUCT_SELECTOR_CALLOUT_HEADING)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "subdued"
}, _i18n.i18n.translate('xpack.enterpriseSearch.overview.setupCta.description', {
  defaultMessage: 'Add search to your app or internal organization with Elastic App Search and Workplace Search. Watch the video to see what you can do when search is made easy.'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
  src: _getting_started.default,
  alt: "",
  className: "enterpriseSearchSetupCta__image"
}))));
exports.SetupGuideCta = SetupGuideCta;