"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api_key_panel = require("../../../shared/api_key/api_key_panel");
var _error_state = require("../../../shared/error_state");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _search_labs_banner = require("../../../shared/search_labs_banner/search_labs_banner");
var _telemetry = require("../../../shared/telemetry");
var _search_header = _interopRequireDefault(require("../../assets/search_header.png"));
var _layout = require("../layout");
var _setup_guide = require("../setup_guide");
var _trial_callout = require("../trial_callout");
var _elasticsearch_product_card = require("./elasticsearch_product_card");
var _ingestion_selector = require("./ingestion_selector");
require("./product_selector.scss");
var _welcome_banner = require("./welcome_banner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProductSelector = () => {
  const {
    config
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    user
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const showErrorConnecting = !!(config.host && errorConnectingMessage);
  // The create index flow does not work without ent-search, when content is updated
  // to no longer rely on ent-search we can always show the Add Content component

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchOverviewPageTemplate, {
    restrictWidth: true,
    grow: true,
    offset: 0,
    customPageSections: true
  }, /*#__PURE__*/_react.default.createElement(_trial_callout.TrialCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "top",
    className: "entSearchProductSelectorHeader"
  }, /*#__PURE__*/_react.default.createElement(_welcome_banner.WelcomeBanner, {
    user: user || undefined,
    image: _search_header.default
  }), /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetSearchChrome, null), /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "viewed",
    metric: "overview"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_api_key_panel.ApiKeyPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.productSelector.overview.title', {
    defaultMessage: 'Ingest your content'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.productSelector.overview.description', {
    defaultMessage: 'The first step in building your search experience is to create a search-optimized Elasticsearch index and import your content into it. Elasticsearch offers several user-friendly options you can choose from that best match your technical expertise and data sources.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_ingestion_selector.IngestionSelector, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), showErrorConnecting && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "error",
    metric: "cannot_connect"
  }), /*#__PURE__*/_react.default.createElement(_error_state.ErrorStateCallout, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.productSelector.overview.createCustom.title', {
    defaultMessage: 'Create a custom search experience'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.productSelector.overview.createCustom.description', {
    defaultMessage: "Once your index is created and populated, you'll be ready to use the full power of Elasticsearch. Build search applications using our out-of-the-box tools and programming language clients, all backed by a robust set of APIs."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_elasticsearch_product_card.ElasticsearchProductCard, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_labs_banner.SearchLabsBanner, null)), !config.host && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuideCta, null))))));
};
exports.ProductSelector = ProductSelector;