"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddResultButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _2 = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddResultButton = () => {
  const {
    openFlyout
  } = (0, _kea.useActions)(_2.AddResultLogic);
  const {
    isAutomated
  } = (0, _kea.useValues)(_.CurationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: openFlyout,
    iconType: "plusInCircle",
    size: "s",
    disabled: isAutomated
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.addResult.buttonLabel', {
    defaultMessage: 'Add result manually'
  }));
};
exports.AddResultButton = AddResultButton;