"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findAnonymizationFieldsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _schemas = require("@kbn/elastic-assistant-common/impl/schemas");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _lodash = _interopRequireDefault(require("lodash"));
var _utils = require("../utils");
var _helpers = require("../../ai_assistant_data_clients/anonymization_fields/helpers");
var _helpers2 = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findAnonymizationFieldsRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_FIND,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _common.buildRouteValidationWithZod)(_schemas.FindAnonymizationFieldsRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _query$fields;
      const {
        query
      } = request;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      // Perform license and authenticated user checks
      const checkResponse = await (0, _helpers2.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const dataClient = await ctx.elasticAssistant.getAIAssistantAnonymizationFieldsDataClient();
      const aggs = {
        field_status: {
          filters: {
            filters: {
              allowed: {
                term: {
                  allowed: true
                }
              },
              anonymized: {
                term: {
                  anonymized: true
                }
              },
              denied: {
                term: {
                  allowed: false
                }
              }
            }
          }
        }
      };
      const result = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.findDocuments({
        perPage: query.per_page,
        page: query.page,
        sortField: query.sort_field,
        sortOrder: query.sort_order,
        filter: query.filter,
        fields: (_query$fields = query.fields) === null || _query$fields === void 0 ? void 0 : _query$fields.map(f => _lodash.default.snakeCase(f)),
        aggs
      }));
      let fullPageResult;
      if (query.all_data) {
        var _query$fields2;
        fullPageResult = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.findDocuments({
          perPage: 1000,
          page: 1,
          fields: (_query$fields2 = query.fields) === null || _query$fields2 === void 0 ? void 0 : _query$fields2.map(f => _lodash.default.snakeCase(f)),
          aggs
        }));
      }
      if (result) {
        var _fullPageResult, _fullPageResult$data$, _fullPageResult2, _fullPageResult3;
        return response.ok({
          body: {
            perPage: result.perPage,
            page: result.page,
            total: result.total,
            data: (0, _helpers.transformESSearchToAnonymizationFields)(result.data),
            ...((_fullPageResult = fullPageResult) !== null && _fullPageResult !== void 0 && _fullPageResult.data.aggregations ? {
              aggregations: (_fullPageResult$data$ = fullPageResult.data.aggregations) !== null && _fullPageResult$data$ !== void 0 ? _fullPageResult$data$ : result.data.aggregations
            } : {}),
            ...((_fullPageResult2 = fullPageResult) !== null && _fullPageResult2 !== void 0 && _fullPageResult2.data ? {
              all: (0, _helpers.transformESSearchToAnonymizationFields)((_fullPageResult3 = fullPageResult) === null || _fullPageResult3 === void 0 ? void 0 : _fullPageResult3.data)
            } : {})
          }
        });
      }
      return response.ok({
        body: {
          perPage: query.per_page,
          page: query.page,
          data: [],
          total: 0
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.findAnonymizationFieldsRoute = findAnonymizationFieldsRoute;