"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPersistedConversation = getPersistedConversation;
var _helpers = require("../../../helpers");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getPersistedConversation({
  logger,
  state,
  conversationsDataClient
}) {
  var _conversation$message;
  logger.debug(() => `${_constants.NodeType.GET_PERSISTED_CONVERSATION}: Node state:\n${JSON.stringify(state, null, 2)}`);
  const conversation = await (conversationsDataClient === null || conversationsDataClient === void 0 ? void 0 : conversationsDataClient.getConversation({
    id: state.conversationId
  }));
  if (!conversation) {
    logger.debug('Requested conversation, because conversation is undefined');
    return {
      conversation: undefined,
      messages: [],
      chatTitle: '',
      lastNode: _constants.NodeType.GET_PERSISTED_CONVERSATION
    };
  }
  logger.debug(`conversationId: ${state.conversationId}`);
  const messages = (0, _helpers.getLangChainMessages)((_conversation$message = conversation.messages) !== null && _conversation$message !== void 0 ? _conversation$message : []);
  if (!state.input) {
    const lastMessage = messages === null || messages === void 0 ? void 0 : messages.splice(-1)[0];
    return {
      conversation,
      messages,
      chatTitle: conversation.title,
      input: lastMessage === null || lastMessage === void 0 ? void 0 : lastMessage.content,
      lastNode: _constants.NodeType.GET_PERSISTED_CONVERSATION
    };
  }
  return {
    conversation,
    messages,
    chatTitle: conversation.title,
    lastNode: _constants.NodeType.GET_PERSISTED_CONVERSATION
  };
}