"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeType = exports.DEFAULT_MAX_REPEATED_GENERATIONS = exports.DEFAULT_MAX_HALLUCINATION_FAILURES = exports.DEFAULT_MAX_GENERATION_ATTEMPTS = exports.ATTACK_DISCOVERY_TAG = exports.ATTACK_DISCOVERY_GRAPH_RUN_NAME = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// LangGraph metadata
const ATTACK_DISCOVERY_GRAPH_RUN_NAME = exports.ATTACK_DISCOVERY_GRAPH_RUN_NAME = 'Attack discovery';
const ATTACK_DISCOVERY_TAG = exports.ATTACK_DISCOVERY_TAG = 'attack-discovery';

// Limits
const DEFAULT_MAX_GENERATION_ATTEMPTS = exports.DEFAULT_MAX_GENERATION_ATTEMPTS = 10;
const DEFAULT_MAX_HALLUCINATION_FAILURES = exports.DEFAULT_MAX_HALLUCINATION_FAILURES = 5;
const DEFAULT_MAX_REPEATED_GENERATIONS = exports.DEFAULT_MAX_REPEATED_GENERATIONS = 3;
const NodeType = exports.NodeType = {
  GENERATE_NODE: 'generate',
  REFINE_NODE: 'refine',
  RETRIEVE_ANONYMIZED_ALERTS_NODE: 'retrieve_anonymized_alerts'
};