"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistantTelemetry = void 0;
var _react = require("react");
var _typed_kibana_context = require("../../context/typed_kibana_context/typed_kibana_context");
var _types = require("../../common/lib/telemetry/events/ai_assistant/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssistantTelemetry = () => {
  const {
    services: {
      telemetry
    }
  } = (0, _typed_kibana_context.useKibana)();
  const reportTelemetry = (0, _react.useCallback)(async ({
    eventType,
    params
  }) => {
    telemetry.reportEvent(eventType, params);
  }, [telemetry]);
  return (0, _react.useMemo)(() => ({
    reportAssistantInvoked: params => reportTelemetry({
      eventType: _types.AssistantEventTypes.AssistantInvoked,
      params
    }),
    reportAssistantMessageSent: params => reportTelemetry({
      eventType: _types.AssistantEventTypes.AssistantMessageSent,
      params
    }),
    reportAssistantQuickPrompt: params => reportTelemetry({
      eventType: _types.AssistantEventTypes.AssistantQuickPrompt,
      params
    }),
    reportAssistantStarterPrompt: params => reportTelemetry({
      eventType: _types.AssistantEventTypes.AssistantStarterPrompt,
      params
    }),
    reportAssistantSettingToggled: params => telemetry.reportEvent(_types.AssistantEventTypes.AssistantSettingToggled, params)
  }), [reportTelemetry, telemetry]);
};
exports.useAssistantTelemetry = useAssistantTelemetry;