"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SkipBottomButton = SkipBottomButton;
var _react = _interopRequireDefault(require("react"));
require("./skip_bottom_button.scss");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SkipBottomButton({
  onClick
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    showOnFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "s",
    onClick: onClick,
    className: "dscSkipButton",
    "data-test-subj": "discoverSkipTableButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.skipToBottomButtonLabel",
    defaultMessage: "Go to end of table"
  })));
}