"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoChartsData = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoChartsData = ({
  textAlign
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: textAlign !== null && textAlign !== void 0 ? textAlign : 'center',
    size: 's',
    css: {
      display: 'flex',
      justifyContent: 'center',
      height: '100%',
      width: '100%',
      alignItems: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.noData",
    defaultMessage: "No data"
  }));
};
exports.NoChartsData = NoChartsData;