"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchCommentRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _api = require("../../../../common/types/api");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const patchCommentRoute = exports.patchCommentRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'patch',
  path: _constants.CASE_COMMENTS_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    })
  },
  routerOptions: {
    access: 'public',
    summary: `Update a case comment or alert`,
    tags: ['oas-tag:cases'],
    description: 'You cannot change the comment type or the owner of a comment.'
    // You must have `all` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on the owner of the case you're updating.
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const query = (0, _runtime_types.decodeWithExcessOrThrow)(_api.AttachmentPatchRequestRt)(request.body);
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const res = await client.attachments.update({
        caseID: request.params.case_id,
        updateRequest: query
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to patch comment in route case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});