"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssignees = void 0;
var _react = require("react");
var _sort = require("../../components/user_profiles/sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssignees = ({
  caseAssignees,
  userProfiles
}) => {
  const {
    assigneesWithProfiles,
    assigneesWithoutProfiles
  } = (0, _react.useMemo)(() => {
    const {
      usersWithProfiles,
      usersWithoutProfiles
    } = caseAssignees.reduce((acc, assignee) => {
      const profile = userProfiles.get(assignee.uid);
      if (profile) {
        acc.usersWithProfiles.push(profile);
      } else {
        acc.usersWithoutProfiles.push({
          uid: assignee.uid
        });
      }
      return acc;
    }, {
      usersWithProfiles: [],
      usersWithoutProfiles: []
    });
    const orderedProf = (0, _sort.sortProfiles)(usersWithProfiles);
    const withProfiles = orderedProf === null || orderedProf === void 0 ? void 0 : orderedProf.map(profile => ({
      uid: profile.uid,
      profile
    }));
    return {
      assigneesWithProfiles: withProfiles !== null && withProfiles !== void 0 ? withProfiles : [],
      assigneesWithoutProfiles: usersWithoutProfiles
    };
  }, [caseAssignees, userProfiles]);
  const allAssignees = (0, _react.useMemo)(() => [...assigneesWithProfiles, ...assigneesWithoutProfiles], [assigneesWithProfiles, assigneesWithoutProfiles]);
  return {
    assigneesWithProfiles,
    assigneesWithoutProfiles,
    allAssignees
  };
};
exports.useAssignees = useAssignees;